/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.dimension;

import crazydev.common.collection.CdIComparableList;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataTableRow;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.builders.IOlapBuilderDimensionListener;
import crazydev.iccube.builder.model.builders.dimension.BaseDimensionBuilder;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderDynamicHierarchies;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderMultiLevelHierarchy;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.stats.OlapDimensionStats;
import crazydev.iccube.olap.schema.stats.OlapHierarchyStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaStats;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderDimensionBuilder<T extends IOlapBuilderHierarchyDef>
extends BaseDimensionBuilder {
    private final Object LOCK = new Object();
    private final List<? extends IOlapBuilderHierarchyDef> defaultHierarchies;
    private final OlapBuilderContext context;
    private final OlapDimension dimension;
    private List<IOlapBuilderDimensionListener> hierarchyBuilders;
    private int defaultHierarchyBuilderIndex;
    private T defaultHierarchyDef;
    private boolean hasArray;
    @Nullable
    private IOlapBuilderDimensionListener.ILineSorter lineSorter;
    private RowsCache rowsCache;
    @Nullable
    private OlapBuilderDynamicHierarchies dynamicHierarchiesBuilder;

    public OlapBuilderDimensionBuilder(OlapBuilderContext context, OlapDimension dimension, List<? extends IOlapBuilderHierarchyDef> hierarchies, T defaultHierarchyDef) {
        this.context = context;
        this.dimension = dimension;
        this.defaultHierarchyDef = defaultHierarchyDef;
        this.defaultHierarchies = hierarchies;
    }

    public void setDynamicBuilder(OlapBuilderDynamicHierarchies hierarchies) {
        this.dynamicHierarchiesBuilder = hierarchies;
    }

    private List<? extends IOlapBuilderHierarchyDef> getDefaultHierarchies(IOlapBuilderTabularDataDef tabularData) {
        if (this.dynamicHierarchiesBuilder == null) {
            return this.defaultHierarchies;
        }
        return this.dynamicHierarchiesBuilder.addDynamicBuilders(this.context, this.defaultHierarchies, tabularData);
    }

    private void initOnFirstRow(IOlapBuilderTabularDataDef tabularData) {
        this.initHierarchies(tabularData);
        this.setupHierarchiesBuilder(tabularData);
    }

    @NotNull
    private void initHierarchies(IOlapBuilderTabularDataDef tabularData) {
        List<IOlapBuilderHierarchyDef> hierarchies = this.getDefaultHierarchies(tabularData);
        this.hierarchyBuilders = new ArrayList<IOlapBuilderDimensionListener>(hierarchies.size());
        int defaultHierarchyBuilderIndex = -1;
        for (int idx = 0; idx < hierarchies.size(); ++idx) {
            IOlapBuilderHierarchyDef hierarchy = hierarchies.get(idx);
            this.hierarchyBuilders.add(hierarchy.createBuilder(this.context, this.dimension));
            if (!hierarchy.isDefault()) continue;
            if (defaultHierarchyBuilderIndex != -1) {
                throw new CdProgrammingException("Building dimension [" + this.dimension.getName(this.context.getNameContext()) + "] : multiple base hierarchy definitions.");
            }
            defaultHierarchyBuilderIndex = idx;
        }
        if (defaultHierarchyBuilderIndex == -1 || !this.defaultHierarchyDef.isDefault()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DEFAULT_HIERARCHY_EXPECTED, new Serializable[]{this.defaultHierarchyDef.getName(), this.dimension.getName(this.context.getNameContext())});
        }
        List<IOlapBuilderHierarchyLevelDef> levels = this.defaultHierarchyDef.getLevels();
        levels.forEach(level -> level.getAttributes().forEach(attributeDef -> {
            OlapBuilderMultiLevelHierarchy hierarchyDef = OlapBuilderMultiLevelHierarchy.create(attributeDef, level);
            this.hierarchyBuilders.add(hierarchyDef.createBuilder(this.context, this.dimension));
        }));
        this.defaultHierarchyBuilderIndex = defaultHierarchyBuilderIndex;
    }

    private void setupHierarchiesBuilder(IOlapBuilderTabularDataDef tabularData) {
        int size = this.hierarchyBuilders.size();
        this.hasArray = false;
        boolean useLineSolver = true;
        for (int i = 0; i < size; ++i) {
            IOlapBuilderDimensionListener.ILineSorter solver;
            IOlapBuilderDimensionListener hierarchyBuilder = this.hierarchyBuilders.get(i);
            hierarchyBuilder.init((IOlapBuilderHierarchyDef)this.defaultHierarchyDef);
            if (useLineSolver && (solver = hierarchyBuilder.getLineSorter()) != null) {
                this.rowsCache = new RowsCache(tabularData);
                if (!solver.checkIsCompatible(this.lineSorter)) {
                    OlapLoggers.BUILDER.warn((Object)("Dimension [" + this.dimension.getNameX() + "], Hierarchies define incompatible auto-solvers , autosort disabled"));
                    useLineSolver = false;
                    this.lineSorter = null;
                } else {
                    this.lineSorter = solver;
                }
            }
            this.hasArray |= hierarchyBuilder.hasColumnDefWithArray();
        }
        if (this.lineSorter != null) {
            OlapLoggers.BUILDER.info((Object)("Dimension [" + this.dimension.getNameX() + "], autosort enabled"));
        }
    }

    @Override
    public void onTableProcessingInit(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        this.startedMS = System.currentTimeMillis();
    }

    @Override
    public void onTableProcessingStarted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        super.onTableProcessingStarted(context, tabularData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
        if (context.isOfflineWriteOnly()) {
            return true;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.hierarchyBuilders == null) {
                this.initOnFirstRow(tabularData);
            }
            if (!this.hasArray) {
                return this.onNewSingleRow(data);
            }
            return this.onNewArrayRow(data);
        }
    }

    @Override
    public void onTableProcessingCompleted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
        if (this.hierarchyBuilders == null) {
            this.initOnFirstRow(tabularData);
        }
        this.resolveLineSolver();
        int size = this.hierarchyBuilders.size();
        for (int i = 0; i < size; ++i) {
            IOlapBuilderDimensionListener hierarchyBuilder = this.hierarchyBuilders.get(i);
            hierarchyBuilder.onProcessingDataCompleted(context);
        }
        if (this.startedMS != -1L && !context.isIncrLoad()) {
            this.dimension.setProcessingElapsedMS(System.currentTimeMillis() - this.startedMS);
        }
        try {
            Logger logger = context.getLoggers().builder();
            if (logger.isDebugEnabled()) {
                ArrayList<OlapHierarchyStats> hierarchyStats = new ArrayList<OlapHierarchyStats>();
                for (OlapHierarchy hierarchy : this.dimension.getHierarchies()) {
                    hierarchyStats.add(hierarchy.createStats());
                }
                OlapDimensionStats dimStats = new OlapDimensionStats(this.dimension.getNameX(), hierarchyStats, this.dimension.getProcessingElapsedMS());
                StringBuilder sb = new StringBuilder();
                OlapSchemaStats.printDimensionStats(sb, dimStats);
                OlapLoggers.BUILDER.debug((Object)("[builder] dimension builder completed : " + this.dimension.getNameX() + " (" + CdStringUtils.formatNice((long)dimStats.getMemberCount()) + ")\n" + String.valueOf(sb)));
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.BUILDER.warn((Object)("[builder] dimension [" + this.dimension.getNameX() + "] stats error "), (Throwable)ex);
        }
    }

    private boolean onNewArrayRow(IOlapBuilderTableRow data) {
        LineMultiplierDecorator decorator = new LineMultiplierDecorator(data);
        do {
            this.onNewSingleRow(decorator);
        } while (decorator.hasNewLine());
        return true;
    }

    private boolean onNewSingleRow(IOlapBuilderTableRow data) {
        if (this.lineSorter != null && !this.lineSorter.mightLoadLine(data)) {
            this.context.assertNotCancelling("add-member");
            this.rowsCache.add(data);
            return true;
        }
        return this.doOnNewSingleRow(data);
    }

    private boolean doOnNewSingleRow(IOlapBuilderTableRow data) {
        this.context.assertNotCancelling("add-member");
        IOlapBuilderDimensionListener baseHierarchyBuilder = this.hierarchyBuilders.get(this.defaultHierarchyBuilderIndex);
        OlapMember baseMember = baseHierarchyBuilder.addToHierarchy(data);
        this.dimension.incrementOnNewLoadRowToBuild();
        int size = this.hierarchyBuilders.size();
        for (int i = 0; i < size; ++i) {
            if (i == this.defaultHierarchyBuilderIndex) continue;
            IOlapBuilderDimensionListener hierarchyBuilder = this.hierarchyBuilders.get(i);
            OlapMember member = hierarchyBuilder.addToHierarchy(data);
            if (member == null && baseMember != null) {
                if (hierarchyBuilder.isAttributeHierarchy()) {
                    member = hierarchyBuilder.addMissingAttributeMember();
                    if (member == null) {
                        throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_ATTRIBUTE_NOT_DEFINED, new Serializable[]{hierarchyBuilder.getHierarchyName(), baseMember.getNameX()});
                    }
                } else {
                    member = hierarchyBuilder.addMissingNoBaseHierarchyMember();
                }
            }
            if (baseMember == null || member == null) continue;
            hierarchyBuilder.addNoBaseBaseLink(member, baseMember);
            OlapBuilderDimensionBuilder.addAttributeMember(baseMember, member);
        }
        return true;
    }

    public static void addAttributeMember(OlapMember baseMember, OlapMember member) {
        if (member.getHierarchy().isParentChild()) {
            return;
        }
        boolean autoAttributes = !member.getDimension().getSchema().disableAutoAttributes();
        boolean hierIsAttribute = member.getHierarchy().isAttributeHierarchy();
        OlapLevel memberLevel = member.getLevel();
        boolean memberOfLastLevel = memberLevel.isLast();
        if (hierIsAttribute) {
            int idx;
            OlapMember attributeBaseMember = OlapHierarchy.getAttributeMember(baseMember, member);
            if (attributeBaseMember != null && (idx = attributeBaseMember.addAttributeMember(member)) <= 0) {
                OlapMember collidingMember = memberLevel.getMemberAtDataIdx(-idx - 1);
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.MEMBER_ATTRIBUTE_NOT_UNIQUE, new Serializable[]{baseMember.getNameX(), member.getNameX(), collidingMember.getNameX()});
            }
        } else if (autoAttributes && memberOfLastLevel && baseMember.getLevel().isLast()) {
            baseMember.addAttributeMember(member);
        }
    }

    private void resolveLineSolver() {
        if (this.lineSorter != null && this.rowsCache != null) {
            try {
                this.lineSorter.onEndProcessing(this.rowsCache.rows, this::doOnNewSingleRow);
            }
            finally {
                this.lineSorter = null;
                this.rowsCache = null;
            }
        }
    }

    private static final class RowsCache {
        private final List<IOlapBuilderDataColumnDef> selectedColumns;
        private final int size;
        private final List<OlapBuilderBufferDataTableRow> rows = new ArrayList<OlapBuilderBufferDataTableRow>();

        RowsCache(IOlapBuilderTabularDataDef tabularData) {
            this.selectedColumns = tabularData.getSelectedColumns();
            this.size = tabularData.getSelectedColumns().stream().mapToInt(IOlapBuilderDataColumnDef::getIndex).max().getAsInt() + 1;
        }

        public void add(IOlapBuilderTableRow data) {
            this.rows.add(new OlapBuilderBufferDataTableRow(this.size, this.selectedColumns, data));
        }

        public boolean isEmpty() {
            return this.rows.isEmpty();
        }
    }

    private static final class LineMultiplierDecorator
    implements IOlapBuilderTableRow {
        private final IOlapBuilderTableRow tableRow;
        int currentLine;
        int maxSize;

        public LineMultiplierDecorator(IOlapBuilderTableRow tableRow) {
            this.tableRow = tableRow;
        }

        @Override
        @Nullable
        public Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef) {
            Comparable data = this.tableRow.getJavaNativeDataValue(columnDef);
            if (data instanceof CdIComparableList) {
                CdIComparableList dataArray = (CdIComparableList)data;
                if (dataArray.size() == 0) {
                    return null;
                }
                this.maxSize = Math.max(this.maxSize, dataArray.size());
                return dataArray.get(this.currentLine);
            }
            return data;
        }

        public boolean hasNewLine() {
            return ++this.currentLine < this.maxSize;
        }
    }
}

