/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.bridge;

import crazydev.common.collection.CdComparableList;
import crazydev.common.collection.CdMultiColumnValue;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeBaseMap;
import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeDef;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactSolveRowError;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.cluster.master.backup.restore.M_RestoreContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;

class OlapSingleBridgeMultipleKeyMap
extends OlapSingleBridgeBaseMap<CdMultiColumnValue> {
    public OlapSingleBridgeMultipleKeyMap(OlapSingleBridgeDef definition) {
        super(definition);
    }

    public OlapSingleBridgeMultipleKeyMap(OlapSingleBridgeDef definition, Map<CdMultiColumnValue, CdComparableList> map) {
        super(definition, map);
    }

    @Override
    protected void doAddRow(IOlapBuilderTableRow row, List<IOlapBuilderDataColumnDef> keyCols, List<IOlapBuilderDataColumnDef> valCols) {
        CdMultiColumnValue key = (CdMultiColumnValue)row.getJavaNativeDataValues(keyCols);
        Object value = row.getJavaNativeDataValues(valCols);
        this.addKeyVal(key, (Comparable)value);
    }

    @Override
    public Comparable getValues(OlapDimension dimension, Comparable key, boolean useUnknownMembers) throws OlapBuilderFactSolveRowError {
        if (key == null) {
            return null;
        }
        if (key instanceof CdMultiColumnValue) {
            CdMultiColumnValue multiKey = (CdMultiColumnValue)key;
            CdComparableList values = (CdComparableList)this.map.get(multiKey);
            if (values == null) {
                return this.logErrorOnMissingKey(dimension, key, useUnknownMembers);
            }
            return values.size() == 1 ? (Comparable)values.get(0) : values;
        }
        throw new CdShouldNotBeHereProgrammingException(key.getClass().getName());
    }

    @Override
    void commitDiff(OlapSingleBridgeBaseMap<CdMultiColumnValue> diff) {
        for (Map.Entry entry : diff.map.entrySet()) {
            CdMultiColumnValue key = (CdMultiColumnValue)entry.getKey();
            CdComparableList value = entry.getValue();
            this.addKeyVal(key, (Comparable)value);
        }
    }

    public static OlapSingleBridgeBaseMap restore(M_RestoreContext context, DataInputStream in, OlapSingleBridgeDef definition) throws IOException {
        Map<CdMultiColumnValue, CdComparableList> map = OlapSingleBridgeMultipleKeyMap.restoreMap(context, in);
        return new OlapSingleBridgeMultipleKeyMap(definition, map);
    }
}

