/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.bridge;

import crazydev.iccube.builder.model.builders.IOlapBuilderTableListener;
import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeBaseMap;
import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeListener;
import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeMultipleKeyMap;
import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeSingleKeyMap;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.impl.OlapBuilderBridgeRef;
import crazydev.iccube.cluster.master.backup.restore.M_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.schema.OlapSchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OlapSingleBridgeDef {
    private final String bridgeTableId;
    private final boolean oneToOne;
    private final List<IOlapBuilderDataColumnDef> keyCols;
    private final List<IOlapBuilderDataColumnDef> valCols;

    public OlapSingleBridgeDef(OlapBuilderBridgeRef bridge) {
        this.bridgeTableId = bridge.getBridgeTable().getId();
        this.oneToOne = bridge.isOneToOne();
        this.keyCols = bridge.getBridgeJoinDef();
        this.valCols = bridge.getBridgeKeyDef();
    }

    public String getTableId() {
        return this.bridgeTableId;
    }

    public IOlapBuilderTableListener createListener(OlapSingleBridgeBaseMap map) {
        return new OlapSingleBridgeListener(map, this);
    }

    public boolean isOneToOne() {
        return this.oneToOne;
    }

    public List<IOlapBuilderDataColumnDef> getKeyCols() {
        return this.keyCols;
    }

    public List<IOlapBuilderDataColumnDef> getValCols() {
        return this.valCols;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapSingleBridgeDef that = (OlapSingleBridgeDef)o;
        if (!this.bridgeTableId.equals(that.bridgeTableId)) {
            return false;
        }
        if (!this.keyCols.equals(that.keyCols)) {
            return false;
        }
        return this.valCols.equals(that.valCols);
    }

    public int hashCode() {
        int result = this.bridgeTableId.hashCode();
        result = 31 * result + this.keyCols.hashCode();
        result = 31 * result + this.valCols.hashCode();
        return result;
    }

    OlapSingleBridgeBaseMap createMap() {
        if (this.keyCols.size() == 1) {
            return new OlapSingleBridgeSingleKeyMap(this);
        }
        return new OlapSingleBridgeMultipleKeyMap(this);
    }

    public void save(S_BackupOutputStream out) throws IOException {
        out.writeUTF8(this.bridgeTableId);
        this.save(out, this.keyCols);
        this.save(out, this.valCols);
    }

    private void save(S_BackupOutputStream out, List<IOlapBuilderDataColumnDef> cols) throws IOException {
        out.writeInt(cols.size());
        for (IOlapBuilderDataColumnDef col : cols) {
            out.writeUTF8(col.getName());
        }
    }

    public static OlapSingleBridgeDef restore(M_RestoreContext context, S_BackupInputStream in) throws IOException {
        String bridgeTableId = in.readUTF8();
        List<String> keyColNames = OlapSingleBridgeDef.restoreColNames(in);
        List<String> valColNames = OlapSingleBridgeDef.restoreColNames(in);
        OlapSchema schema = context.getSchema();
        OlapSingleBridgeDef bridgeDef = schema.lookupBridgeDefinitions(bridgeTableId, keyColNames, valColNames);
        if (bridgeDef != null) {
            return bridgeDef;
        }
        throw new RuntimeException("internal error: missing bridge definition [" + bridgeTableId + "] keys:" + String.valueOf(keyColNames) + "vals:" + String.valueOf(valColNames));
    }

    private static List<String> restoreColNames(S_BackupInputStream in) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        int count = in.readInt();
        for (int ii = 0; ii < count; ++ii) {
            String name = in.readUTF8();
            names.add(name);
        }
        return names;
    }
}

