/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.model.builders.bridge;

import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.impl.OlapBuilderBridgeRef;
import java.util.List;
import java.util.stream.Collectors;

public class OlapBridgeDef {
    private final List<OlapSingleBridgeDef> singleBridges;

    public OlapBridgeDef(List<OlapBuilderBridgeRef> bridge) {
        this.singleBridges = bridge.stream().map(OlapSingleBridgeDef::new).collect(Collectors.toList());
    }

    public List<OlapSingleBridgeDef> getSingleBridgeDefs() {
        return this.singleBridges;
    }

    public boolean isLookupTable(IOlapBuilderDataViewLinksDef link) {
        if (this.singleBridges.size() != 1) {
            return false;
        }
        OlapSingleBridgeDef def = this.singleBridges.get(0);
        if (!def.isOneToOne()) {
            return false;
        }
        List<IOlapBuilderDataColumnDef> keyCols = def.getKeyCols();
        if (keyCols.size() != 1) {
            return false;
        }
        IOlapBuilderDataColumnDef keyCol = keyCols.get(0);
        if (!keyCol.getType().isLookupTable()) {
            return false;
        }
        List<IOlapBuilderDataColumnDef> valCols = def.getValCols();
        if (valCols.size() != 1) {
            return false;
        }
        IOlapBuilderDataColumnDef valCol = valCols.get(0);
        if (!valCol.getType().isLookupTable()) {
            return false;
        }
        List<IOlapBuilderDataColumnDef> factsJoinCols = link.getToColumns();
        if (factsJoinCols.size() != 1) {
            return false;
        }
        IOlapBuilderDataColumnDef factsJoinCol = factsJoinCols.get(0);
        if (!factsJoinCol.getType().isLookupTable()) {
            return false;
        }
        return keyCol.getType() == factsJoinCol.getType();
    }

    public String getLookupTableTableId() {
        return this.singleBridges.get(0).getTableId();
    }

    public IOlapBuilderDataColumnDef getLookupTableFrom() {
        return this.singleBridges.get(0).getKeyCols().get(0);
    }

    public IOlapBuilderDataColumnDef getLookupTableTo() {
        return this.singleBridges.get(0).getValCols().get(0);
    }

    public int hashCode() {
        return this.singleBridges.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OlapBridgeDef) {
            OlapBridgeDef bridge = (OlapBridgeDef)obj;
            return this.singleBridges.size() == bridge.singleBridges.size() && this.singleBridges.equals(bridge.singleBridges);
        }
        return false;
    }
}

