/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.goodies.headerdef.measure;

import crazydev.common.mdx.scanner.token.CdMdxIdentifierToken;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.goodies.headerdef.measure.annotation.OlapBuilderAggregationTypeAnnotation;
import crazydev.iccube.builder.goodies.headerdef.measure.annotation.OlapBuilderFormatAnnotation;
import crazydev.iccube.builder.goodies.headerdef.parser.OlapBuilderColumnDefInfoParser;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.impl.OlapBuilderMeasure;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.olap.entity.properties.cell.OlapFormatStringName;
import java.io.Serializable;
import java.util.List;

public final class OlapBuilderMeasureDefParser
extends OlapBuilderColumnDefInfoParser<IOlapBuilderMeasureDef> {
    public static final OlapBuilderMeasureDefParser INSTANCE = new OlapBuilderMeasureDefParser();
    private static final String MEASURES_COLUMN_PREFIX = "Measures";

    private OlapBuilderMeasureDefParser() {
    }

    @Override
    protected IOlapBuilderMeasureDef parseDefinition(List<CdMdxIdentifierToken> tokens, IOlapBuilderDataColumnDef columnDef, MdxIdentifierExpression identifierExpression) {
        String stringDefinition = columnDef.getName();
        String firstToken = this.findTokenValue(tokens, 0);
        if (!MEASURES_COLUMN_PREFIX.equals(firstToken)) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.NOT_MEASURE_COLUMN, new Serializable[]{stringDefinition});
        }
        if (tokens.size() != 2) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_DATA_MEAS_COLUMN_INVALID_TOKENS, new Serializable[]{stringDefinition, Integer.valueOf(tokens.size())});
        }
        String secondToken = this.findTokenValue(tokens, 1);
        List<String> annotations = this.parseAnnotations(identifierExpression, stringDefinition);
        OlapAggregationType aggregationType = OlapAggregationType.SUM;
        OlapFormatStringName namedFormatString = null;
        for (String annotation : annotations) {
            if (OlapBuilderAggregationTypeAnnotation.INSTANCE.isAnnotation(annotation)) {
                aggregationType = OlapBuilderAggregationTypeAnnotation.INSTANCE.parseEntity(stringDefinition, annotation);
                continue;
            }
            if (OlapBuilderFormatAnnotation.INSTANCE.isAnnotation(annotation)) {
                namedFormatString = OlapBuilderFormatAnnotation.INSTANCE.parseEntity(stringDefinition, annotation);
                continue;
            }
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_UNEXPECTED_ANNOTATION, new Serializable[]{annotation, stringDefinition});
        }
        return namedFormatString != null ? new OlapBuilderMeasure(secondToken, aggregationType, columnDef, "FORMAT_STRING = '" + String.valueOf(namedFormatString) + "'") : new OlapBuilderMeasure(secondToken, aggregationType, columnDef);
    }
}

