/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.goodies.headerdef.hierarchy;

import crazydev.common.mdx.scanner.token.CdMdxIdentifierToken;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.goodies.headerdef.dimension.annotation.OlapBuilderDefaultTimeDimensionAnnotation;
import crazydev.iccube.builder.goodies.headerdef.dimension.annotation.OlapBuilderStatisticalDimensionAnnotation;
import crazydev.iccube.builder.goodies.headerdef.dimension.annotation.OlapBuilderTimeDimensionAnnotation;
import crazydev.iccube.builder.goodies.headerdef.hierarchy.OlapBuilderHierarchyInfo;
import crazydev.iccube.builder.goodies.headerdef.hierarchy.OlapBuilderLevelInfo;
import crazydev.iccube.builder.goodies.headerdef.hierarchy.annotation.OlapBuilderAllLevelAnnotation;
import crazydev.iccube.builder.goodies.headerdef.hierarchy.annotation.OlapBuilderAllMemberAnnotation;
import crazydev.iccube.builder.goodies.headerdef.hierarchy.annotation.OlapBuilderDefaultHierarchyAnnotation;
import crazydev.iccube.builder.goodies.headerdef.level.annotation.OlapBuilderLevelTypeAnnotation;
import crazydev.iccube.builder.goodies.headerdef.level.annotation.OlapBuilderLevelUniqueAnnotation;
import crazydev.iccube.builder.goodies.headerdef.parser.OlapBuilderColumnDefInfoParser;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.impl.OlapBuilderAllLevelParsedDefinition;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import java.io.Serializable;
import java.util.List;

public final class OlapBuilderHierarchyInfoParser
extends OlapBuilderColumnDefInfoParser<OlapBuilderHierarchyInfo> {
    public static final OlapBuilderHierarchyInfoParser INSTANCE = new OlapBuilderHierarchyInfoParser();

    private OlapBuilderHierarchyInfoParser() {
    }

    @Override
    protected OlapBuilderHierarchyInfo parseDefinition(List<CdMdxIdentifierToken> tokens, IOlapBuilderDataColumnDef columnDef, MdxIdentifierExpression identifierExpression) {
        String stringDefinition = columnDef.getName();
        if (tokens.size() > 3) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_DATA_COLUMN_NAME_TOO_LONG, new Serializable[]{stringDefinition});
        }
        if (tokens.size() < 2) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_DATA_COLUMN_NAME_TOO_SHORT, new Serializable[]{stringDefinition});
        }
        String firstToken = this.findTokenValue(tokens, 0);
        String secondToken = this.findTokenValue(tokens, 1);
        String thirdToken = this.findTokenValue(tokens, 2);
        boolean isDefaultHierarchy = false;
        OlapLevelType levelType = null;
        String allLevel = null;
        String allMember = null;
        boolean isLevelUnique = false;
        boolean isTimeDimension = false;
        boolean isDefaultTimeDimension = false;
        boolean isStatisticalDimension = false;
        List<String> annotations = this.parseAnnotations(identifierExpression, stringDefinition);
        for (String annotation : annotations) {
            if (OlapBuilderDefaultHierarchyAnnotation.INSTANCE.isAnnotation(annotation)) {
                isDefaultHierarchy = true;
                continue;
            }
            if (OlapBuilderAllLevelAnnotation.INSTANCE.isAnnotation(annotation)) {
                allLevel = OlapBuilderAllLevelAnnotation.INSTANCE.parseEntity(stringDefinition, annotation);
                continue;
            }
            if (OlapBuilderAllMemberAnnotation.INSTANCE.isAnnotation(annotation)) {
                allMember = OlapBuilderAllMemberAnnotation.INSTANCE.parseEntity(stringDefinition, annotation);
                continue;
            }
            if (OlapBuilderLevelTypeAnnotation.INSTANCE.isAnnotation(annotation)) {
                levelType = OlapBuilderLevelTypeAnnotation.INSTANCE.parseEntity(stringDefinition, annotation);
                continue;
            }
            if (OlapBuilderLevelUniqueAnnotation.INSTANCE.isAnnotation(annotation)) {
                isLevelUnique = true;
                continue;
            }
            if (OlapBuilderTimeDimensionAnnotation.INSTANCE.isAnnotation(annotation)) {
                isTimeDimension = true;
                continue;
            }
            if (OlapBuilderDefaultTimeDimensionAnnotation.INSTANCE.isAnnotation(annotation)) {
                isDefaultTimeDimension = true;
                continue;
            }
            if (OlapBuilderStatisticalDimensionAnnotation.INSTANCE.isAnnotation(annotation)) {
                isStatisticalDimension = true;
                continue;
            }
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_UNEXPECTED_ANNOTATION, new Serializable[]{annotation, stringDefinition});
        }
        OlapBuilderAllLevelParsedDefinition allLevelDefinition = allLevel == null && allMember == null ? OlapBuilderAllLevelParsedDefinition.UNDEFINED : OlapBuilderAllLevelParsedDefinition.create(allLevel, allMember);
        OlapBuilderLevelInfo property = new OlapBuilderLevelInfo(thirdToken, columnDef);
        return new OlapBuilderHierarchyInfo(firstToken, isDefaultHierarchy, allLevelDefinition, secondToken, levelType, isLevelUnique, property, isTimeDimension, isDefaultTimeDimension, isStatisticalDimension);
    }
}

