/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.goodies.headerdef.factory;

import crazydev.common.collection.CdSingleItemList;
import crazydev.common.mdx.error.CdMdxException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.datasource.file.OlapBuilderDirectoryConnection;
import crazydev.iccube.builder.datasource.file.OlapBuilderFileDataSource;
import crazydev.iccube.builder.datasource.file.OlapBuilderFileLineDataTable;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.goodies.headerdef.factory.OlapBuilderBaseLineCubeDefFactory;
import crazydev.iccube.builder.goodies.headerdef.factory.OlapBuilderLineCubeDefFactory;
import crazydev.iccube.builder.goodies.headerdef.factory.OlapBuilderOneTable2Multiple;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="singleFileCubeFactory")
public class OlapBuilderSingleFileHeaderCubeDefFactory
extends OlapBuilderBaseLineCubeDefFactory<OlapBuilderDirectoryConnection, OlapBuilderFileDataSource> {
    public static final CdProperty DEFINITION_FILE = new CdReadWriteProperty(OlapBuilderSingleFileHeaderCubeDefFactory.class, "definitionFile");
    public static final CdProperty FILE_DEF = new CdReadWriteProperty(OlapBuilderSingleFileHeaderCubeDefFactory.class, "fileDef");
    @XmlElement(name="directory", required=true)
    private String directory;
    @XmlElement(name="fileDef", required=true)
    private OlapBuilderLineCubeDefFactory.FactsDefinitionLine fileDef;
    @XmlTransient
    private IOlapBuilderTabularDataDef factTable;
    @XmlTransient
    private List<IOlapBuilderTabularDataDef> dimensions;

    public OlapBuilderSingleFileHeaderCubeDefFactory() {
        this.fileDef = new OlapBuilderLineCubeDefFactory.FactsDefinitionLine();
    }

    public OlapBuilderSingleFileHeaderCubeDefFactory(String cubeName, String cubeDescription, String directoryName, OlapBuilderLineCubeDefFactory.FactsDefinitionLine fileDef) {
        super(cubeName, cubeDescription, false);
        this.directory = directoryName;
        this.fileDef = fileDef;
    }

    @Override
    protected void onCreateCubeDefinitionBegin(OlapBuilderErrorManager errorManager, OlapBuilderDirectoryConnection connection, OlapBuilderFileDataSource dataSource) {
        super.onCreateCubeDefinitionBegin(errorManager, connection, dataSource);
        OlapBuilderFileLineDataTable fileTable = new OlapBuilderFileLineDataTable(this.fileDef.getFileName(), this.fileDef.getColumnSeparator(), this.fileDef.getCommentMarker());
        fileTable.buildColumnsFromHeader(null, connection, errorManager);
        dataSource.link(fileTable);
        OlapBuilderOneTable2Multiple<OlapBuilderDirectoryConnection> builder = null;
        try {
            builder = new OlapBuilderOneTable2Multiple<OlapBuilderDirectoryConnection>(fileTable);
        }
        catch (CdMdxException ex) {
            errorManager.addError(OlapBuilderErrorCode.CUBE_FACTORY_FILE_COLUMNS_DEF_MDX_ERROR, new Serializable[]{this.fileDef.getFileName(), ex.getError()});
        }
        this.factTable = builder.getFacts();
        if (this.factTable == null) {
            errorManager.addError(OlapBuilderErrorCode.CUBE_FACTORY_FILE_COLUMNS_WITHOUT_MEASURES, new Serializable[]{this.fileDef.getFileName()});
        }
        this.dimensions = builder.getDimensions();
        if (this.dimensions.isEmpty()) {
            errorManager.addError(OlapBuilderErrorCode.CUBE_FACTORY_FILE_COLUMNS_WITHOUT_DIMENSIONS, new Serializable[]{this.fileDef.getFileName()});
        }
    }

    @Override
    protected OlapBuilderFileDataSource createDataSource() {
        return new OlapBuilderFileDataSource(this.xmlFile, this.directory);
    }

    @Override
    protected IOlapBuilderTabularDataDef getFactDataTable(OlapBuilderDirectoryConnection connection, OlapBuilderErrorManager errorManager) {
        return this.factTable;
    }

    @Override
    protected List<IOlapBuilderTabularDataDef> getDimensionTables(OlapBuilderDirectoryConnection connection) {
        return this.dimensions;
    }

    @Override
    protected List<OlapBuilderLineCubeDefFactory.IFileLineDefinition> getDefinitions() {
        return new CdSingleItemList((Object)this.fileDef);
    }

    @Nullable
    public File getDefinitionFile() {
        String fileDefName;
        String string = fileDefName = this.fileDef == null ? null : this.fileDef.getFileName();
        if (fileDefName == null) {
            return this.directory == null ? null : new File(this.directory);
        }
        if (this.directory == null) {
            return new File(fileDefName);
        }
        return new File(this.directory, fileDefName);
    }

    public void setDefinitionFile(@Nullable File definitionFile) {
        if (this.fileDef == null) {
            this.fileDef = new OlapBuilderLineCubeDefFactory.FactsDefinitionLine();
        }
        if (definitionFile == null) {
            this.directory = null;
            this.fileDef.setFileName(null);
        } else {
            this.directory = definitionFile.getParentFile().getPath();
            this.fileDef.setFileName(definitionFile.getName());
        }
    }
}

