/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.goodies.headerdef.factory;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.goodies.headerdef.OlapBuilderXmlDefinitionDimensionInfo;
import crazydev.iccube.builder.goodies.headerdef.factory.OlapBuilderDataSourceCubeDefFactory;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class OlapBuilderLineCubeDefFactory<CONNECTION extends IOlapBuilderConnection, DATASOURCE extends OlapBuilderBaseDataSource<CONNECTION>>
extends OlapBuilderDataSourceCubeDefFactory<CONNECTION, DATASOURCE> {
    public static final String DEFAULT_COLUMN_SEPARATOR = ",";
    public static final String DEFAULT_COMMENT_MARKER = "#";
    public static final String RESERVED_SYMBOLS = "[].()@<>";

    protected OlapBuilderLineCubeDefFactory() {
    }

    public OlapBuilderLineCubeDefFactory(String cubeName, String cubeDescription, boolean aggregateDataSourceFacts) {
        super(cubeName, cubeDescription, aggregateDataSourceFacts);
    }

    @Override
    protected void validate(OlapBuilderErrorManager errorManager) {
        List<IFileLineDefinition> definitions = this.getDefinitions();
        for (IFileLineDefinition entityDefinition : definitions) {
            if (StringUtils.isEmpty((CharSequence)entityDefinition.getColumnSeparator())) {
                entityDefinition.setColumnSeparator(DEFAULT_COLUMN_SEPARATOR);
            } else if (StringUtils.isEmpty((CharSequence)entityDefinition.getCommentMarker())) {
                entityDefinition.setCommentMarker(DEFAULT_COMMENT_MARKER);
            } else if (StringUtils.isNotEmpty((CharSequence)entityDefinition.getColumnSeparator()) && entityDefinition.getColumnSeparator().equals(entityDefinition.getCommentMarker())) {
                errorManager.addError(OlapBuilderErrorCode.COLUMN_SEPARATOR_AND_COMMENT_MARKER_ARE_IDENTICAL, new Serializable[0]);
            }
            if (RESERVED_SYMBOLS.contains(entityDefinition.getColumnSeparator())) {
                errorManager.addError(OlapBuilderErrorCode.INVALID_COLUMN_SEPARATOR, new Serializable[0]);
            }
            if (!RESERVED_SYMBOLS.contains(entityDefinition.getCommentMarker())) continue;
            errorManager.addError(OlapBuilderErrorCode.INVALID_COMMENT_MARKER, new Serializable[0]);
        }
    }

    protected abstract List<IFileLineDefinition> getDefinitions();

    protected static interface IFileLineDefinition {
        public String getColumnSeparator();

        public String getCommentMarker();

        public void setColumnSeparator(String var1);

        public void setCommentMarker(String var1);
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class DimensionDefinitionLine
    extends OlapBuilderDataSourceCubeDefFactory.DimensionDefinition
    implements IFileLineDefinition {
        @XmlElement(name="columnSeparator", required=true)
        protected String columnSeparator;
        @XmlElement(name="commentMarker", required=false)
        protected String commentMarker;

        public DimensionDefinitionLine() {
        }

        public DimensionDefinitionLine(OlapBuilderXmlDefinitionDimensionInfo dimensionInfo, String columnSeparator, String commentMarker) {
            super(dimensionInfo);
            this.columnSeparator = columnSeparator;
            this.commentMarker = commentMarker;
        }

        @Override
        public String getColumnSeparator() {
            return this.columnSeparator;
        }

        @Override
        public String getCommentMarker() {
            return this.commentMarker;
        }

        @Override
        public void setColumnSeparator(String columnSeparator) {
            this.columnSeparator = columnSeparator;
        }

        @Override
        public void setCommentMarker(String commentMarker) {
            this.commentMarker = commentMarker;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class FactsDefinitionLine
    extends OlapBuilderDataSourceCubeDefFactory.FactsDefinition
    implements IFileLineDefinition {
        public static final CdProperty COLUMN_SEPARATOR = new CdReadWriteProperty(FactsDefinitionLine.class, "columnSeparator");
        public static final CdProperty COMMENT_MARKER = new CdReadWriteProperty(FactsDefinitionLine.class, "commentMarker");
        @XmlElement(name="columnSeparator", required=true)
        protected String columnSeparator;
        @XmlElement(name="commentMarker", required=false)
        protected String commentMarker;

        public FactsDefinitionLine() {
        }

        public FactsDefinitionLine(String fileName) {
            this(fileName, OlapBuilderLineCubeDefFactory.DEFAULT_COLUMN_SEPARATOR, OlapBuilderLineCubeDefFactory.DEFAULT_COMMENT_MARKER);
        }

        public FactsDefinitionLine(String fileName, String columnSeparator, String commentMarker) {
            super(fileName);
            this.columnSeparator = columnSeparator;
            this.commentMarker = commentMarker;
        }

        @Override
        public String getColumnSeparator() {
            return this.columnSeparator;
        }

        @Override
        public String getCommentMarker() {
            return this.commentMarker;
        }

        @Override
        public void setColumnSeparator(String columnSeparator) {
            this.columnSeparator = columnSeparator;
        }

        @Override
        public void setCommentMarker(String commentMarker) {
            this.commentMarker = commentMarker;
        }
    }
}

