/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.goodies.headerdef.dimension;

import crazydev.common.collection.CdAction;
import crazydev.common.collection.CdCollections;
import crazydev.common.collection.CdFilter;
import crazydev.common.collection.CdPair;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.goodies.headerdef.OlapBuilderXmlDefinitionDimensionInfo;
import crazydev.iccube.builder.goodies.headerdef.hierarchy.OlapBuilderHierarchyInfo;
import crazydev.iccube.builder.goodies.headerdef.hierarchy.OlapBuilderHierarchyInfoParser;
import crazydev.iccube.builder.goodies.headerdef.hierarchy.OlapBuilderLevelInfo;
import crazydev.iccube.builder.goodies.headerdef.parser.IOlapBuilderDefinitionParser;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.impl.OlapBuilderAllLevelParsedDefinition;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderMultiLevelHierarchy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class OlapBuilderHierarchiesParser
implements IOlapBuilderDefinitionParser<List<IOlapBuilderDataColumnDef>, CdPair<List<IOlapBuilderHierarchyDef>, OlapBuilderHierarchyInfo>> {
    @Nullable
    OlapBuilderXmlDefinitionDimensionInfo dimInfo;
    public static final OlapBuilderHierarchiesParser INSTANCE = new OlapBuilderHierarchiesParser();

    private OlapBuilderHierarchiesParser() {
    }

    public OlapBuilderHierarchiesParser(OlapBuilderXmlDefinitionDimensionInfo dimInfo) {
        this.dimInfo = dimInfo;
    }

    @Override
    public CdPair<List<IOlapBuilderHierarchyDef>, OlapBuilderHierarchyInfo> parse(List<IOlapBuilderDataColumnDef> dataColumns) {
        IOlapBuilderDataColumnDef firstDuplicatedColumn = (IOlapBuilderDataColumnDef)CdCollections.findFirstDuplicate(dataColumns);
        if (firstDuplicatedColumn != null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_MULTILEVEL_DATA_COLUMN_NAME_DUPLICATED, new Serializable[]{firstDuplicatedColumn.getName()});
        }
        ArrayList<OlapBuilderMultiLevelHierarchy> hierarchies = new ArrayList<OlapBuilderMultiLevelHierarchy>();
        ArrayList<OlapBuilderHierarchyInfo> headerInfos = new ArrayList<OlapBuilderHierarchyInfo>();
        for (IOlapBuilderDataColumnDef dataColumn : dataColumns) {
            headerInfos.add((OlapBuilderHierarchyInfo)OlapBuilderHierarchyInfoParser.INSTANCE.parse(dataColumn));
        }
        final LinkedList<String> hierarchyNames = new LinkedList<String>();
        CdCollections.apply(headerInfos, (CdAction)new CdAction<OlapBuilderHierarchyInfo>(){
            {
                Objects.requireNonNull(this$0);
            }

            public void apply(OlapBuilderHierarchyInfo olapBuilderHierarchyInfo) {
                String hierarchyName = olapBuilderHierarchyInfo.getName();
                if (!hierarchyNames.contains(hierarchyName)) {
                    hierarchyNames.add(hierarchyName);
                }
            }
        });
        for (final String hierarchyName : hierarchyNames) {
            final LinkedHashMap<String, OlapBuilderHierarchyInfo> levelTypes = new LinkedHashMap<String, OlapBuilderHierarchyInfo>();
            CdCollections.apply(headerInfos, (CdAction)new CdAction<OlapBuilderHierarchyInfo>(){
                {
                    Objects.requireNonNull(this$0);
                }

                public void apply(OlapBuilderHierarchyInfo headerInfo) {
                    if (hierarchyName.equals(headerInfo.getName())) {
                        levelTypes.put(headerInfo.getLevelName(), headerInfo);
                    }
                }
            });
            boolean isDefaultHierarchy = this.isDefault(hierarchyName, headerInfos, hierarchyNames);
            List<IOlapBuilderHierarchyLevelDef> levels = this.buildLevels(levelTypes, hierarchyName, headerInfos);
            OlapBuilderAllLevelParsedDefinition allLevelDef = this.findAllLevelDefInfo(hierarchyName, headerInfos);
            hierarchies.add(new OlapBuilderMultiLevelHierarchy(hierarchyName, isDefaultHierarchy, allLevelDef, levels));
        }
        return new CdPair(hierarchies, (Object)this.findDimensionInfo(headerInfos));
    }

    private List<IOlapBuilderHierarchyLevelDef> buildLevels(Map<String, OlapBuilderHierarchyInfo> levelsNames, String hierarchyName, List<OlapBuilderHierarchyInfo> headerInfos) {
        ArrayList<IOlapBuilderHierarchyLevelDef> levels = new ArrayList<IOlapBuilderHierarchyLevelDef>();
        for (Map.Entry<String, OlapBuilderHierarchyInfo> levelTypeEntry : levelsNames.entrySet()) {
            ArrayList<IOlapBuilderDataColumnDef> keysCol = new ArrayList<IOlapBuilderDataColumnDef>();
            IOlapBuilderDataColumnDef nameCol = null;
            boolean isKeyUniqueInLevel = false;
            boolean isNameUniqueInLevel = false;
            ArrayList<IOlapBuilderPropertyDef> properties = new ArrayList<IOlapBuilderPropertyDef>();
            for (int i = 0; i < headerInfos.size(); ++i) {
                OlapBuilderHierarchyInfo hierarchyHeaderInfo = headerInfos.get(i);
                if (!hierarchyName.equals(hierarchyHeaderInfo.getName()) || !levelTypeEntry.getKey().equals(hierarchyHeaderInfo.getLevelName())) continue;
                OlapBuilderLevelInfo propertyDef = hierarchyHeaderInfo.getProperty();
                if (propertyDef.isKey()) {
                    keysCol.add(propertyDef.asColumn());
                } else if (propertyDef.isName()) {
                    nameCol = propertyDef.asColumn();
                } else {
                    properties.add(propertyDef.asBuilderProperty());
                }
                if (!hierarchyHeaderInfo.isLevelUnique()) continue;
                isKeyUniqueInLevel |= propertyDef.isKey();
                isNameUniqueInLevel |= propertyDef.isName();
            }
            if (isNameUniqueInLevel && keysCol.isEmpty()) {
                isKeyUniqueInLevel = true;
            }
            OlapBuilderHierarchyInfo value = levelTypeEntry.getValue();
            String levelName = levelTypeEntry.getKey();
            OlapBuilderHierarchyLevel olapLevel = new OlapBuilderHierarchyLevel(levelName, null, value.getLevelType(), isKeyUniqueInLevel, isNameUniqueInLevel, keysCol, nameCol, properties);
            if (this.dimInfo != null && this.dimInfo.getOrderMembers() != null) {
                olapLevel.setOrderMembersByType(this.dimInfo.getOrderMembers());
            }
            levels.add(olapLevel);
        }
        return levels;
    }

    private boolean isDefault(final String hierarchyName, List<OlapBuilderHierarchyInfo> headerInfos, List<String> hierarchyNames) {
        boolean isExplicitlyDefinedAsDefault = CdCollections.hasElement(headerInfos, (CdFilter)new CdFilter<OlapBuilderHierarchyInfo>(){
            {
                Objects.requireNonNull(this$0);
            }

            public boolean accept(OlapBuilderHierarchyInfo headerInfo) {
                return headerInfo.getName().equals(hierarchyName) && headerInfo.isDefault();
            }
        });
        if (isExplicitlyDefinedAsDefault || hierarchyNames.size() == 1) {
            return true;
        }
        boolean hasExplicitlyDefinedDefaultHierarchy = CdCollections.hasElement(headerInfos, (CdFilter)new CdFilter<OlapBuilderHierarchyInfo>(this){
            {
                Objects.requireNonNull(this$0);
            }

            public boolean accept(OlapBuilderHierarchyInfo headerInfo) {
                return headerInfo.isDefault();
            }
        });
        boolean isFirstHierarchy = hierarchyName.equals(hierarchyNames.get(0));
        return !hasExplicitlyDefinedDefaultHierarchy && isFirstHierarchy;
    }

    private OlapBuilderAllLevelParsedDefinition findAllLevelDefInfo(final String hierarchyName, List<OlapBuilderHierarchyInfo> headerInfos) {
        OlapBuilderHierarchyInfo headerInfo = (OlapBuilderHierarchyInfo)CdCollections.findFirst(headerInfos, (CdFilter)new CdFilter<OlapBuilderHierarchyInfo>(){
            {
                Objects.requireNonNull(this$0);
            }

            public boolean accept(OlapBuilderHierarchyInfo headerInfo) {
                return headerInfo.getName().equals(hierarchyName) && !OlapBuilderAllLevelParsedDefinition.UNDEFINED.equals(headerInfo.getAllLevelDef());
            }
        });
        return headerInfo != null ? headerInfo.getAllLevelDef() : OlapBuilderAllLevelParsedDefinition.UNDEFINED;
    }

    private OlapBuilderHierarchyInfo findDimensionInfo(List<OlapBuilderHierarchyInfo> headerInfos) {
        OlapBuilderHierarchyInfo hierarchyInfo = (OlapBuilderHierarchyInfo)CdCollections.findFirst(headerInfos, (CdFilter)new CdFilter<OlapBuilderHierarchyInfo>(this){
            {
                Objects.requireNonNull(this$0);
            }

            public boolean accept(OlapBuilderHierarchyInfo olapBuilderHierarchyInfo) {
                return olapBuilderHierarchyInfo.isDefaultTime() || olapBuilderHierarchyInfo.isTime() || olapBuilderHierarchyInfo.isStatistical();
            }
        });
        return hierarchyInfo != null ? hierarchyInfo : headerInfos.get(0);
    }
}

