/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.goodies.headerdef.dimension;

import crazydev.common.collection.CdPair;
import crazydev.iccube.builder.goodies.headerdef.OlapBuilderXmlDefinitionDimensionInfo;
import crazydev.iccube.builder.goodies.headerdef.dimension.OlapBuilderHierarchiesParser;
import crazydev.iccube.builder.goodies.headerdef.hierarchy.OlapBuilderHierarchyInfo;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderBaseDimension;
import java.util.List;

public abstract class OlapBuilderHeaderDefinitionDimensionFactory {
    public static IOlapBuilderDimensionDef<IOlapBuilderHierarchyDef> create(IOlapBuilderTabularDataDef tabularData, String dimensionName, String cubeName) {
        CdPair<List<IOlapBuilderHierarchyDef>, OlapBuilderHierarchyInfo> parsedInfo = OlapBuilderHierarchiesParser.INSTANCE.parse(tabularData.getSelectedColumns());
        List hierarchies = (List)parsedInfo.fst;
        OlapBuilderHierarchyInfo dimensionInfo = (OlapBuilderHierarchyInfo)parsedInfo.snd;
        return OlapBuilderHeaderDefinitionDimensionFactory.createDimensionImpl(tabularData, dimensionName, hierarchies, cubeName, dimensionInfo.isDefaultTime(), dimensionInfo.isTime());
    }

    public static IOlapBuilderDimensionDef<IOlapBuilderHierarchyDef> create(IOlapBuilderTabularDataDef tabularData, OlapBuilderXmlDefinitionDimensionInfo dimensionInfo, String cubeName) {
        OlapBuilderHierarchiesParser hierarchiesParser = new OlapBuilderHierarchiesParser(dimensionInfo);
        CdPair<List<IOlapBuilderHierarchyDef>, OlapBuilderHierarchyInfo> parsedInfo = hierarchiesParser.parse(tabularData.getSelectedColumns());
        boolean isDefaultTime = dimensionInfo.isDefaultTimeDimension() || ((OlapBuilderHierarchyInfo)parsedInfo.snd).isDefaultTime();
        boolean isTime = dimensionInfo.isTimeDimension() || ((OlapBuilderHierarchyInfo)parsedInfo.snd).isTime();
        return OlapBuilderHeaderDefinitionDimensionFactory.createDimensionImpl(tabularData, dimensionInfo.getName(), (List)parsedInfo.fst, cubeName, isDefaultTime, isTime);
    }

    private static IOlapBuilderDimensionDef<IOlapBuilderHierarchyDef> createDimensionImpl(IOlapBuilderTabularDataDef tabularData, String dimensionName, List<IOlapBuilderHierarchyDef> hierarchies, String cubeName, boolean isDefaultTime, boolean isTime) {
        String dimensionId = cubeName + "." + dimensionName;
        if (isDefaultTime) {
            return OlapBuilderBaseDimension.createMultiLevelTimeDimension(tabularData, dimensionName, dimensionId, hierarchies);
        }
        if (isTime) {
            return OlapBuilderBaseDimension.createMultiLevelNonDefaultTimeDimension(tabularData, dimensionName, dimensionId, hierarchies);
        }
        return OlapBuilderBaseDimension.createMultiLevelDimension(tabularData, dimensionName, dimensionId, hierarchies);
    }
}

