/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.goodies.headerdef.column;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.goodies.headerdef.parser.IOlapBuilderDefinitionParser;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Strings;

public class OlapBuilderColumnDefinitionParser
implements IOlapBuilderDefinitionParser<String, OlapBuilderDataColumn> {
    private static final OlapBuilderColumnDefinitionParser INSTANCE = new OlapBuilderColumnDefinitionParser();

    private OlapBuilderColumnDefinitionParser() {
    }

    public static OlapBuilderColumnDefinitionParser getInstance() {
        return INSTANCE;
    }

    @Override
    public OlapBuilderDataColumn parse(String columnDefinition) {
        OlapBuilderInputType dataType;
        String columnName;
        Pattern pattern = Pattern.compile("<[^<>]*>$");
        Matcher matcher = pattern.matcher(columnDefinition);
        int matches = 0;
        int matchStart = -1;
        int matchEnd = -1;
        while (matcher.find()) {
            matchStart = matcher.start();
            matchEnd = matcher.end();
            ++matches;
        }
        boolean isArray = false;
        if (matches == 0) {
            columnName = columnDefinition;
            dataType = OlapBuilderInputType.STRING;
        } else if (matches == 1) {
            String match = columnDefinition.substring(matchStart, matchEnd);
            if (!Strings.CS.endsWith((CharSequence)columnDefinition, (CharSequence)match)) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_INCORRECT_SYNTAX_FOR_COLUMN_WITH_ERROR, new Serializable[]{columnDefinition, "remaining character after the input type definition : " + match});
            }
            if (match.contains("Array:")) {
                isArray = true;
                match = match.replace("Array:", "");
            }
            if ((dataType = OlapBuilderInputType.findByFullName(match)) == null) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_INCORRECT_SYNTAX_FOR_COLUMN_WITH_ERROR, new Serializable[]{columnDefinition, "unknown input type : " + match});
            }
            columnName = columnDefinition.substring(0, matchStart);
        } else {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.HEADER_INCORRECT_SYNTAX_FOR_COLUMN_WITH_ERROR, new Serializable[]{columnDefinition, "multiple input type definitions"});
        }
        OlapBuilderDataColumn column = new OlapBuilderDataColumn(dataType, "STRING", columnName.trim());
        if (isArray) {
            column.setIsArray();
        }
        return column;
    }
}

