/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.factory.cube;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.factory.cube.OlapBuilderBaseCubeDefFactory;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHeaderCubeDef;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="classCubeFactory")
public class OlapBuilderClassCubeDefFactory
extends OlapBuilderBaseCubeDefFactory {
    public static final CdProperty CLASS_NAME = new CdReadWriteProperty(OlapBuilderClassCubeDefFactory.class, "cubeDefinitionClassName");
    @XmlElement(name="cubeDefinitionClassName", required=true)
    private String cubeDefinitionClassName;

    public OlapBuilderClassCubeDefFactory() {
    }

    public OlapBuilderClassCubeDefFactory(String cubeName, String cubeDescription, String cubeDefinitionClassName) {
        super(cubeName, cubeDescription, false);
        this.cubeDefinitionClassName = cubeDefinitionClassName;
    }

    public OlapBuilderClassCubeDefFactory(String cubeName, String cubeDescription, Class<? extends IOlapBuilderHeaderCubeDef> clazz) {
        super(cubeName, cubeDescription, false);
        this.cubeDefinitionClassName = clazz.getName();
    }

    @Override
    public IOlapBuilderHeaderCubeDef createCubeDefinition(OlapBuilderConnectionPool connectionPool, OlapBuilderErrorManager errorManager) {
        this.validate(errorManager);
        try {
            Class<?> clazz = Class.forName(this.cubeDefinitionClassName);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            return (IOlapBuilderHeaderCubeDef)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.CUBE_CLASS_WAS_NOT_FOUND, new Serializable[]{this.cubeDefinitionClassName});
        }
        catch (ClassCastException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.CUBE_CLASS_NOT_IMPLEMENT_FRAMEWORK_INTERFACE, new Serializable[]{this.cubeDefinitionClassName, IOlapBuilderCubeDef.class.getName()});
        }
        catch (InstantiationException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.CUBE_CLASS_INSTANTIATION_EXCEPTION, new Serializable[]{this.cubeDefinitionClassName, ex.getLocalizedMessage()});
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.CUBE_CLASS_HAS_NO_DEFAULT_ACCESSIBLE_CONSTRUCTOR, new Serializable[]{this.cubeDefinitionClassName, ex.getLocalizedMessage()});
        }
        catch (InvocationTargetException ex) {
            throw new OlapBuilderErrorException((Throwable)ex, new OlapBuilderError(OlapBuilderErrorCode.CUBE_CLASS_CONSTRUCTION_ERROR, new Serializable[]{this.cubeDefinitionClassName, ex.getLocalizedMessage()}));
        }
    }

    private void validate(OlapBuilderErrorManager errorManager) {
        if (this.cubeDefinitionClassName == null) {
            errorManager.addError(OlapBuilderErrorCode.MISSING_OR_UNKNOWN_ENTITY, new Serializable[]{"JAVA class", this.getName()});
        }
    }
}

