/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.executor.rowprocessing;

import crazydev.common.exception.CdRuntimeException;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.common.executor.IOlapThreadPoolExecutorTask;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderTableRowProcessingTask<CONNECTION extends IOlapBuilderConnection>
implements IOlapThreadPoolExecutorTask {
    private static final double PERIOD_ROW_COUNT = 100000.0;
    protected final OlapBuilderContext context;
    protected final IOlapBuilderDataTableDef<CONNECTION> table;
    private final String fullNameForEndUser;
    @Nullable
    private IOlapBuilderTablePartitionKey partitionKey;

    public OlapBuilderTableRowProcessingTask(OlapBuilderContext context, IOlapBuilderDataTableDef<CONNECTION> table, String fullNameForEndUser, @Nullable IOlapBuilderTablePartitionKey partitionKey) {
        this.context = context;
        this.table = table;
        this.fullNameForEndUser = fullNameForEndUser;
        this.partitionKey = partitionKey;
    }

    @Override
    public abstract void execute();

    protected void executeRow(IOlapBuilderTableRow row, int rowNb) {
        try {
            this.table.onNewRow(this.context, this.partitionKey, rowNb, row);
        }
        catch (CdRuntimeException ex) {
            OlapBuilderErrorException bEx;
            if (ex instanceof OlapBuilderErrorException && ((OlapBuilderErrorException)ex).isIgnoreDataLine()) {
                bEx = (OlapBuilderErrorException)ex;
            } else {
                OlapLoggers.BUILDER_TABLE.error((Object)("table row error (" + rowNb + ")"), (Throwable)ex);
                OlapBuilderError error = new OlapBuilderError(ex.getError(), OlapBuilderErrorCode.LINE_TABLE_ON_PROCESS_LINE, new Serializable[]{this.fullNameForEndUser, Integer.valueOf(rowNb)});
                bEx = new OlapBuilderErrorException((Throwable)ex, error);
            }
            if (this.context.handleErrors()) {
                this.context.onError(bEx);
            }
            throw bEx;
        }
    }

    protected void executeRows(List<IOlapBuilderTableRow> rows, int batchRowOffset) {
        try {
            this.table.onNewRows(this.context, this.partitionKey, rows, batchRowOffset);
        }
        catch (CdRuntimeException ex) {
            OlapBuilderErrorException bEx;
            if (ex instanceof OlapBuilderErrorException && ((OlapBuilderErrorException)ex).isIgnoreDataLine()) {
                bEx = (OlapBuilderErrorException)ex;
            } else {
                int rowNb = this.context.getProcessingRowNumber();
                OlapLoggers.BUILDER_TABLE.error((Object)("table row error in batch (" + rowNb + ")"), (Throwable)ex);
                OlapBuilderError error = new OlapBuilderError(ex.getError(), OlapBuilderErrorCode.LINE_TABLE_ON_PROCESS_LINE, new Serializable[]{this.fullNameForEndUser, Integer.valueOf(rowNb)});
                bEx = new OlapBuilderErrorException((Throwable)ex, error);
            }
            if (this.context.handleErrors()) {
                this.context.onError(bEx);
            }
            throw bEx;
        }
    }
}

