/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.executor.common;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class OlapBuilderTableProcessingInfo {
    private final Object statsLOCK = new Object();
    private final IOlapBuilderDataTableDef table;
    private final List<IOlapBuilderTableRowReader> readers;
    private final AtomicInteger readersDoneCount;
    private final long tableProcessingStartMS = System.currentTimeMillis();
    private long tableProcessingEndMS = -1L;
    private int readerReadCompletedCount;

    public OlapBuilderTableProcessingInfo(IOlapBuilderDataTableDef table, List<IOlapBuilderTableRowReader> readers) {
        this.table = table;
        this.readers = readers;
        this.readersDoneCount = new AtomicInteger(readers.size());
    }

    public boolean onTableRowProcessingDone(IOlapBuilderTableRowReader rowReader) {
        if (!this.readers.contains(rowReader)) {
            throw new RuntimeException("internal error : missing row-reader for table [%s] [partition:%s]".formatted(this.table.getName(), rowReader.getPartitionKey()));
        }
        if (this.readersDoneCount.get() == 0) {
            throw new RuntimeException("internal error : inconsistent row-reader done for table [%s] [partition:%s]".formatted(this.table.getName(), rowReader.getPartitionKey()));
        }
        int count = this.readersDoneCount.decrementAndGet();
        return count == 0;
    }

    public IOlapBuilderDataTableDef getTable() {
        IOlapBuilderTableRowReader reader = this.readers.get(0);
        IOlapBuilderDataTableDef table = reader.getTable();
        return table;
    }

    public String getTableName() {
        IOlapBuilderDataTableDef table = this.getTable();
        return table.getName();
    }

    public List<IOlapBuilderTableRowReader> getReaders() {
        return this.readers;
    }

    public void onTableProcessingPreStarted(OlapBuilderContext context) {
        if (context.getLoggers().builder().isDebugEnabled()) {
            context.getLoggers().builder().debug((Object)("[table] [" + this.getTableName() + "] processing pre-started"));
        }
        IOlapBuilderDataTableDef table = this.getTable();
        table.preInit(context);
    }

    public void onTableProcessingStarted(OlapBuilderContext context) {
        if (context.getLoggers().builder().isDebugEnabled()) {
            context.getLoggers().builder().debug((Object)("table [" + this.getTableName() + "] processing started"));
        }
        context.onProgressEvent("tableProcessingStarted", new Serializable[]{this.getTableName()});
        context.onTableReadStarted(this.getTableName(), this.readers.size(), new Date());
        IOlapBuilderDataTableDef table = this.getTable();
        table.init(context);
        table.onTableRowProcessingStarted(context);
    }

    public void onTablePartitionReadStarted(OlapBuilderContext context, IOlapBuilderTableRowReader reader) {
        context.onTablePartitionReadStarted(this.getTableName(), reader.getName(), new Date());
    }

    public void onTablePartitionReadProgress(OlapBuilderContext context, IOlapBuilderTableRowReader reader, long readRowCount, int readRowCountPerSec, int processingQueuedTaskCount, long processingQueueTaskSize) {
        context.onTablePartitionReadProgress(this.getTableName(), reader.getName(), new Date(), readRowCount, readRowCountPerSec, processingQueuedTaskCount, processingQueueTaskSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTablePartitionReadCompleted(OlapBuilderContext context, IOlapBuilderTableRowReader reader, long rowCount) {
        context.onTablePartitionReadCompleted(this.getTableName(), reader.getName(), new Date(), rowCount);
        boolean tableReadDone = false;
        Object object = this.statsLOCK;
        synchronized (object) {
            if (++this.readerReadCompletedCount >= this.readers.size()) {
                tableReadDone = true;
            }
        }
        if (tableReadDone) {
            context.onTableReadCompleted(this.getTableName(), new Date(), this.computeRowNb());
        }
    }

    public void onTablePartitionProcessingCompleted(OlapBuilderContext context, IOlapBuilderTableRowReader reader) {
        context.onTablePartitionProcessingCompleted(this.getTableName(), reader.getName(), new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTableReaderProcessingCompleted(IOlapBuilderTableRowReader reader) {
        long nowMS = System.currentTimeMillis();
        Object object = this.statsLOCK;
        synchronized (object) {
            if (nowMS > this.tableProcessingEndMS) {
                this.tableProcessingEndMS = nowMS;
            }
        }
    }

    public void onTableProcessingCompleted(OlapBuilderContext context) {
        IOlapBuilderDataTableDef table = this.getTable();
        table.onTableProcessingCompleted(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTableProcessingFinally(OlapBuilderContext context) {
        long elapsedMS;
        IOlapBuilderDataTableDef table = this.getTable();
        table.onTableProcessingFinally(context);
        long nowMS = System.currentTimeMillis();
        Object object = this.statsLOCK;
        synchronized (object) {
            elapsedMS = (this.tableProcessingEndMS == -1L ? nowMS : this.tableProcessingEndMS) - this.tableProcessingStartMS;
        }
        Logger logger = context.getLoggers().builderTable();
        if (elapsedMS != 0L && logger.isDebugEnabled()) {
            logger.debug((Object)("table [" + this.getTableName() + "] processing speed : " + CdStringUtils.formatNice((long)(1000L * this.computeRowNb() / elapsedMS)) + " rows/sec."));
        }
        context.onProgressEvent("tableProcessingDone", new Serializable[]{this.getTableName()});
        context.onTableProcessingCompleted(this.getTableName(), new Date(), this.computeRowNb());
    }

    private long computeRowNb() {
        long rowNb = 0L;
        int size = this.readers.size();
        for (int ii = 0; ii < size; ++ii) {
            IOlapBuilderTableRowReader reader = this.readers.get(ii);
            rowNb += (long)reader.rowNb();
        }
        return rowNb;
    }

    public String toString() {
        IOlapBuilderDataTableDef table = this.getTable();
        return table.getName();
    }
}

