/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.executor.common;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableRequestedPartitionKeys;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.executor.common.OlapBuilderTableProcessingInfo;
import crazydev.iccube.builder.executor.rowreading.OlapBuilderTableRowReadingTaskExecutor;
import crazydev.iccube.builder.executor.rowreading.OlapBuilderTableRowReadingTaskFactory;
import crazydev.iccube.builder.executor.rowreading.OlapBuilderTableRowReadingTaskInfo;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.impl.browsing.IOlapBuilderBrowsingDataTableInfo;
import crazydev.iccube.builder.model.impl.browsing.OlapBuilderBrowsingDataTableInfo;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import crazydev.iccube.olap.component.command.builtin.IOlapEngineRequestedPartitions;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderTableProcessingHelper {
    public static <CONNECTION extends IOlapBuilderConnection> void processTable__(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy, IOlapBuilderDataTableDef<CONNECTION> table) {
        OlapBuilderTableProcessingHelper.processTable__(context, connectionPool, processingSchedulingPolicy, table, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <CONNECTION extends IOlapBuilderConnection> void processTable__(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy, IOlapBuilderDataTableDef<CONNECTION> table, @Nullable OlapBuilderBrowsingDataTableInfo browsingInfo) {
        OlapEngineRequestContext olapEngineRequestContext = context.getEngineContext();
        try {
            olapEngineRequestContext.setupBuilderLoadExecutors(browsingInfo != null);
            ArrayList<IOlapBuilderDataTableDef> tables = new ArrayList<IOlapBuilderDataTableDef>();
            tables.add(table);
            OlapBuilderTableProcessingHelper.processTables(context, connectionPool, processingSchedulingPolicy, tables, null, browsingInfo);
            olapEngineRequestContext.releaseBuilderLoadExecutors(browsingInfo != null);
        }
        catch (Throwable throwable) {
            olapEngineRequestContext.releaseBuilderLoadExecutors(browsingInfo != null);
            throw throwable;
        }
    }

    public static void processTables(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy, List<IOlapBuilderDataTableDef> tables) {
        OlapBuilderTableProcessingHelper.processTables(context, connectionPool, processingSchedulingPolicy, tables, null, null);
    }

    public static void processTableForLoadPartitions(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy, Collection<IOlapBuilderDataTableDef> tables, IOlapEngineRequestedPartitions partitions) {
        OlapBuilderTableProcessingHelper.processTables(context, connectionPool, schedulingPolicy, tables, partitions, null);
    }

    public static void processTables(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy, Collection<IOlapBuilderDataTableDef> tables, @Nullable IOlapEngineRequestedPartitions partitions, @Nullable IOlapBuilderBrowsingDataTableInfo browsingInfo) {
        IntOpenHashSet depths = new IntOpenHashSet();
        for (IOlapBuilderDataTableDef table : tables) {
            Integer depth = table.getDepth();
            if (depth == null) continue;
            depths.add(depth.intValue());
        }
        if (depths.isEmpty()) {
            OlapLoggers.BUILDER.debug((Object)("process tables at depth [empty] : [ " + tables.stream().map(t -> t.getName() + ":" + t.getDepth()).collect(Collectors.joining(", ")) + " ]"));
            OlapBuilderTableProcessingHelper._processTables(context, connectionPool, schedulingPolicy, tables, partitions, browsingInfo);
            return;
        }
        int[] depthsArray = depths.toIntArray();
        Arrays.sort(depthsArray);
        ArrayList<IOlapBuilderDataTableDef> myTables = new ArrayList<IOlapBuilderDataTableDef>();
        Object object = depthsArray;
        int n = ((int[])object).length;
        for (int i = 0; i < n; ++i) {
            Integer depth = object[i];
            for (IOlapBuilderDataTableDef tableDef : tables) {
                if (!depth.equals(tableDef.getDepth())) continue;
                myTables.add(tableDef);
            }
            OlapLoggers.BUILDER.debug((Object)("process tables at depth [" + depth + "] : [ " + myTables.stream().map(t -> t.getName() + ":" + t.getDepth()).collect(Collectors.joining(", ")) + " ]"));
            OlapBuilderTableProcessingHelper._processTables(context, connectionPool, schedulingPolicy, myTables, partitions, browsingInfo);
            myTables.clear();
        }
        object = tables.iterator();
        while (object.hasNext()) {
            IOlapBuilderDataTableDef tableDef = (IOlapBuilderDataTableDef)object.next();
            if (tableDef.getDepth() != null) continue;
            myTables.add(tableDef);
        }
        OlapLoggers.BUILDER.debug((Object)("process tables at depth [null] : [ " + myTables.stream().map(t -> t.getName() + ":" + t.getDepth()).collect(Collectors.joining(", ")) + " ]"));
        OlapBuilderTableProcessingHelper._processTables(context, connectionPool, schedulingPolicy, myTables, partitions, browsingInfo);
    }

    private static void _processTables(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy, Collection<IOlapBuilderDataTableDef> tables, @Nullable IOlapEngineRequestedPartitions partitions, @Nullable IOlapBuilderBrowsingDataTableInfo browsingInfo) {
        if (tables.isEmpty()) {
            return;
        }
        PostOrder postOrder = OlapBuilderTableProcessingHelper.setupPostOrderTables(schedulingPolicy, tables);
        if (postOrder == null) {
            OlapBuilderTableProcessingHelper.doProcessTables(context, connectionPool, schedulingPolicy, tables, partitions, browsingInfo);
        } else {
            Logger logger = context.getLoggers().builder();
            List<IOlapBuilderDataTableDef> postOrderTables = postOrder.postOrderTables;
            if (logger.isDebugEnabled()) {
                for (IOlapBuilderDataTableDef postOrderTable : postOrderTables) {
                    logger.debug((Object)("[s:POST_ORDER] view( table : " + postOrderTable.getName() + " )"));
                }
            }
            OlapBuilderTableProcessingHelper.doProcessTables(context, connectionPool, OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER, postOrderTables, partitions, browsingInfo);
            List<IOlapBuilderDataTableDef> otherTables = postOrder.otherTables;
            if (otherTables != null && !otherTables.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    for (IOlapBuilderDataTableDef otherTable : otherTables) {
                        logger.debug((Object)("[s:OTHER] view( table : " + otherTable.getName() + " )"));
                    }
                }
                OlapBuilderTableProcessingHelper.doProcessTables(context, connectionPool, schedulingPolicy, otherTables, partitions, browsingInfo);
            }
        }
    }

    private static void doProcessTables(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy, Collection<IOlapBuilderDataTableDef> tables, @Nullable IOlapEngineRequestedPartitions partitions, @Nullable IOlapBuilderBrowsingDataTableInfo browsingInfo) {
        Logger logger = context.getLoggers().builder();
        ArrayList<IOlapBuilderDataTableDef> ignoredTables = new ArrayList<IOlapBuilderDataTableDef>();
        ArrayList<OlapBuilderTableProcessingInfo> tableInfos = new ArrayList<OlapBuilderTableProcessingInfo>();
        for (IOlapBuilderDataTableDef iOlapBuilderDataTableDef : tables) {
            if (iOlapBuilderDataTableDef.hasListeners()) {
                int maxRowCount = browsingInfo != null && browsingInfo.isAttachedTo(iOlapBuilderDataTableDef) ? browsingInfo.getMaxRowCount() : -1;
                OlapBuilderTableRequestedPartitionKeys requestedPartitions = partitions != null ? partitions.getPartitions(iOlapBuilderDataTableDef.getName()) : null;
                List<IOlapBuilderTableRowReader> readers = iOlapBuilderDataTableDef.createRowReaders(context, processingSchedulingPolicy, connectionPool, requestedPartitions, maxRowCount);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("table [" + iOlapBuilderDataTableDef.getName() + "] : " + readers.size() + "  reader(s)"));
                }
                if (readers.isEmpty()) {
                    logger.debug((Object)("table [" + iOlapBuilderDataTableDef.getName() + "] : *** ignored *** (reason: no reader)"));
                    ignoredTables.add(iOlapBuilderDataTableDef);
                    continue;
                }
                OlapBuilderTableProcessingInfo tableInfo = new OlapBuilderTableProcessingInfo(iOlapBuilderDataTableDef, readers);
                tableInfos.add(tableInfo);
                if (readers.size() <= 1 || processingSchedulingPolicy != OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER) continue;
                throw new RuntimeException("internal error : multiple readers for table with POST_ORDER processing scheduling policy [" + iOlapBuilderDataTableDef.getName() + "]");
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("table [" + iOlapBuilderDataTableDef.getName() + "] : *** ignored *** (reason: no listener)"));
        }
        if (!ignoredTables.isEmpty()) {
            logger.debug((Object)"ignored table(s) processing (incr. load save point setup)");
            for (IOlapBuilderDataTableDef<Object> iOlapBuilderDataTableDef : ignoredTables) {
                logger.debug((Object)("- table : " + iOlapBuilderDataTableDef.getName()));
            }
        }
        OlapBuilderTableProcessingHelper.processTables(context, tableInfos, processingSchedulingPolicy, browsingInfo);
    }

    private static void processTables(OlapBuilderContext context, List<OlapBuilderTableProcessingInfo> tableInfos, OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy, @Nullable IOlapBuilderBrowsingDataTableInfo browsingInfo) {
        if (context.isOfflineActive() || tableInfos.size() == 1) {
            OlapBuilderTableProcessingHelper.processTablesOneByOne(context, tableInfos, processingSchedulingPolicy, browsingInfo);
        } else {
            OlapBuilderTableProcessingHelper.processTablesInParallel(context, tableInfos, processingSchedulingPolicy, browsingInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTablesOneByOne(OlapBuilderContext context, List<OlapBuilderTableProcessingInfo> tableInfos, OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy, @Nullable IOlapBuilderBrowsingDataTableInfo browsingInfo) {
        OlapBuilderTableProcessingInfo tableInfo;
        int ii;
        int size = tableInfos.size();
        for (ii = 0; ii < tableInfos.size(); ++ii) {
            tableInfo = tableInfos.get(ii);
            tableInfo.onTableProcessingPreStarted(context);
        }
        for (ii = 0; ii < size; ++ii) {
            tableInfo = tableInfos.get(ii);
            context.onProcessingTableRowStart(tableInfo.getTable());
            try {
                tableInfo.onTableProcessingStarted(context);
                OlapThreadPoolExecutorTaskSchedulingPolicy readingSchedulingPolicy = OlapThreadPoolExecutorTaskSchedulingPolicy.NONE;
                List<OlapBuilderTableRowReadingTaskInfo> readerTaskInfos = OlapBuilderTableProcessingHelper.createRowReadingTaskInfos(tableInfo, processingSchedulingPolicy);
                OlapBuilderTableRowReadingTaskFactory tasks = new OlapBuilderTableRowReadingTaskFactory(readingSchedulingPolicy, context, readerTaskInfos, browsingInfo);
                OlapBuilderTableRowReadingTaskExecutor readingExecutor = context.getBuilderReadingExecutor();
                readingExecutor.process(context, tasks);
                continue;
            }
            finally {
                tableInfo.onTableProcessingFinally(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTablesInParallel(OlapBuilderContext context, List<OlapBuilderTableProcessingInfo> tableInfos, OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy, @Nullable IOlapBuilderBrowsingDataTableInfo browsingInfo) {
        OlapBuilderTableProcessingInfo tableInfo;
        int ii;
        int size = tableInfos.size();
        for (ii = 0; ii < size; ++ii) {
            tableInfo = tableInfos.get(ii);
            tableInfo.onTableProcessingPreStarted(context);
        }
        for (ii = 0; ii < size; ++ii) {
            tableInfo = tableInfos.get(ii);
            context.onProcessingTableRowStart(tableInfo.getTable());
        }
        ArrayList<OlapBuilderTableProcessingInfo> startedTableInfos = new ArrayList<OlapBuilderTableProcessingInfo>();
        try {
            for (int ii2 = 0; ii2 < size; ++ii2) {
                OlapBuilderTableProcessingInfo tableInfo2 = tableInfos.get(ii2);
                tableInfo2.onTableProcessingStarted(context);
                startedTableInfos.add(tableInfo2);
            }
            OlapThreadPoolExecutorTaskSchedulingPolicy readingSchedulingPolicy = OlapThreadPoolExecutorTaskSchedulingPolicy.NONE;
            List<OlapBuilderTableRowReadingTaskInfo> readerTaskInfos = OlapBuilderTableProcessingHelper.createRowReadingTaskInfos(tableInfos, processingSchedulingPolicy);
            OlapBuilderTableRowReadingTaskFactory tasks = new OlapBuilderTableRowReadingTaskFactory(readingSchedulingPolicy, context, readerTaskInfos, browsingInfo);
            OlapBuilderTableRowReadingTaskExecutor readingExecutor = context.getBuilderReadingExecutor();
            readingExecutor.process(context, tasks);
        }
        finally {
            int startedTableInfosSize = startedTableInfos.size();
            for (int ii3 = 0; ii3 < startedTableInfosSize; ++ii3) {
                OlapBuilderTableProcessingInfo tableInfo3 = (OlapBuilderTableProcessingInfo)startedTableInfos.get(ii3);
                tableInfo3.onTableProcessingFinally(context);
            }
        }
    }

    private static List<OlapBuilderTableRowReadingTaskInfo> createRowReadingTaskInfos(OlapBuilderTableProcessingInfo processingTableInfo, OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy) {
        ArrayList<OlapBuilderTableProcessingInfo> processingTableInfos = new ArrayList<OlapBuilderTableProcessingInfo>();
        processingTableInfos.add(processingTableInfo);
        return OlapBuilderTableProcessingHelper.createRowReadingTaskInfos(processingTableInfos, processingSchedulingPolicy);
    }

    private static List<OlapBuilderTableRowReadingTaskInfo> createRowReadingTaskInfos(List<OlapBuilderTableProcessingInfo> processingTableInfos, OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy) {
        ArrayList<OlapBuilderTableRowReadingTaskInfo> rowReadingTaskInfos = new ArrayList<OlapBuilderTableRowReadingTaskInfo>();
        for (OlapBuilderTableProcessingInfo processingTableInfo : processingTableInfos) {
            List<IOlapBuilderTableRowReader> readers = processingTableInfo.getReaders();
            for (IOlapBuilderTableRowReader reader : readers) {
                OlapBuilderTableRowReadingTaskInfo rowReadingTableInfo = new OlapBuilderTableRowReadingTaskInfo(processingTableInfo, reader, processingSchedulingPolicy);
                rowReadingTaskInfos.add(rowReadingTableInfo);
            }
        }
        return rowReadingTaskInfos;
    }

    @Nullable
    private static PostOrder setupPostOrderTables(OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy, Collection<IOlapBuilderDataTableDef> tables) {
        if (processingSchedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER) {
            return null;
        }
        ArrayList<IOlapBuilderDataTableDef> postOrderTables = new ArrayList<IOlapBuilderDataTableDef>();
        ArrayList<IOlapBuilderDataTableDef> otherTables = new ArrayList<IOlapBuilderDataTableDef>();
        for (IOlapBuilderDataTableDef table : tables) {
            if (table.hasPostOrderListener()) {
                postOrderTables.add(table);
                continue;
            }
            otherTables.add(table);
        }
        if (postOrderTables.isEmpty()) {
            return null;
        }
        return new PostOrder(postOrderTables, otherTables);
    }

    private static class PostOrder {
        final List<IOlapBuilderDataTableDef> postOrderTables;
        final List<IOlapBuilderDataTableDef> otherTables;

        public PostOrder(List<IOlapBuilderDataTableDef> postOrderTables, List<IOlapBuilderDataTableDef> otherTables) {
            this.postOrderTables = postOrderTables;
            this.otherTables = otherTables;
        }
    }
}

