/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.executor.common;

import crazydev.common.collection.CdSetList;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderContextMode;
import crazydev.iccube.builder.OlapBuilderSchemaMain;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.executor.common.OlapBuilderTableProcessingHelper;
import crazydev.iccube.builder.model.builders.OlapBuilderAbstractTableListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.browsing.IOlapBuilderBrowsingDataTableInfo;
import crazydev.iccube.builder.model.impl.browsing.OlapBuilderBrowsingDataTableInfo;
import crazydev.iccube.builder.model.impl.browsing.OlapBuilderBrowsingDataTableInfoWithPredicate;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTableRow;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTableRows;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderBaseDataView;
import crazydev.iccube.builder.model.impl.view.common.OlapBuilderViewCycleDetector;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import crazydev.iccube.olap.component.command.builtin.OlapEngineLoadSchemaParams;
import crazydev.iccube.olap.component.command.builtin.OlapEngineOfflineMode;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderTableHelper {
    private OlapBuilderTableHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OlapBuilderBaseDataTableRows browseTabularData(OlapEngineRequestContext engineRequestContext, @Nullable String snapshot, OlapBuilderConnectionPool connectionPool, @Nullable IOlapBuilderSchemaDef schemaDef, IOlapBuilderTabularDataDef tabularData, final boolean convertValues, int pageSize, int pageNumber) {
        List<IOlapBuilderDataColumnDef> columns;
        if (schemaDef != null && tabularData instanceof IOlapBuilderDataViewDef) {
            OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI(true, schemaDef, (IOlapBuilderDataViewDef)tabularData);
        }
        if ((columns = tabularData.getSelectedColumns()).isEmpty()) {
            return new OlapBuilderBaseDataTableRows(tabularData, Collections.emptyList());
        }
        final OlapBuilderBrowsingDataTableInfo tabularDataBrowsingInfo = new OlapBuilderBrowsingDataTableInfo(tabularData, pageSize, pageNumber);
        TableListener tabularDataProcessor = new TableListener(tabularData, new Predicate<IOlapBuilderTableRow>(){
            int rowNb = 1;

            @Override
            public boolean test(IOlapBuilderTableRow row) {
                if (tabularDataBrowsingInfo.isDone()) {
                    return false;
                }
                Object[] values = new Object[columns.size()];
                for (int idx = 0; idx < columns.size(); ++idx) {
                    IOlapBuilderDataColumnDef column = (IOlapBuilderDataColumnDef)columns.get(idx);
                    Comparable nativeValue = row.getJavaNativeDataValue(column);
                    values[idx] = nativeValue != null && convertValues && !column.isArray() ? column.getType().getTypeConverter().toJavaNativeValue(column.getName(), nativeValue) : nativeValue;
                }
                tabularDataBrowsingInfo.onRowBrowsed(new OlapBuilderBaseDataTableRow(this.rowNb++, values));
                return !tabularDataBrowsingInfo.isDone();
            }
        });
        try {
            engineRequestContext.setupBuilderLoadExecutors(true);
            OlapBuilderTableHelper.readTabularDataEx(engineRequestContext, schemaDef, snapshot, connectionPool, tabularData, tabularDataBrowsingInfo, tabularDataProcessor);
            OlapBuilderBaseDataTableRows olapBuilderBaseDataTableRows = new OlapBuilderBaseDataTableRows(tabularData, tabularDataBrowsingInfo.getRows());
            return olapBuilderBaseDataTableRows;
        }
        finally {
            engineRequestContext.releaseBuilderLoadExecutors(true);
        }
    }

    public static boolean readTabularData(OlapEngineRequestContext engineRequestContext, @Nullable String snapshot, OlapBuilderConnectionPool connectionPool, @Nullable IOlapBuilderSchemaDef schemaDef, IOlapBuilderTabularDataDef tabularData, Predicate<IOlapBuilderTableRow> visitor) {
        return OlapBuilderTableHelper.readTabularData(engineRequestContext, snapshot, connectionPool, schemaDef, tabularData, visitor, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readTabularData(OlapEngineRequestContext engineRequestContext, @Nullable String snapshot, OlapBuilderConnectionPool connectionPool, @Nullable IOlapBuilderSchemaDef schemaDef, IOlapBuilderTabularDataDef tabularData, Predicate<IOlapBuilderTableRow> visitor, int maxRows) {
        if (schemaDef != null && tabularData instanceof IOlapBuilderDataViewDef) {
            OlapBuilderSchemaMain.solveViewsColumnsBestEffortUI(true, schemaDef, (IOlapBuilderDataViewDef)tabularData);
        }
        OlapBuilderBrowsingDataTableInfoWithPredicate tabularDataBrowsingInfo = new OlapBuilderBrowsingDataTableInfoWithPredicate(tabularData, visitor, maxRows);
        TableListener tabularDataProcessor = new TableListener(tabularData, tabularDataBrowsingInfo);
        try {
            engineRequestContext.setupBuilderLoadExecutors(true);
            boolean bl = OlapBuilderTableHelper.readTabularDataEx(engineRequestContext, schemaDef, snapshot, connectionPool, tabularData, tabularDataBrowsingInfo, tabularDataProcessor);
            return bl;
        }
        finally {
            engineRequestContext.releaseBuilderLoadExecutors(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readTabularDataEx(OlapEngineRequestContext engineRequestContext, IOlapBuilderSchemaDef schemaDef, @Nullable String snapshot, OlapBuilderConnectionPool connectionPool, IOlapBuilderTabularDataDef tabularData, IOlapBuilderBrowsingDataTableInfo tabularDataBrowsingInfo, TableListener tabularDataProcessor) {
        tabularData.addListener(tabularDataProcessor);
        try {
            OlapThreadPoolExecutorTaskSchedulingPolicy processingSchedulingPolicy = OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER;
            CdSetList<IOlapBuilderDataTableDef> tables = tabularData.getUnderlyingTables();
            BuilderContext context = new BuilderContext(engineRequestContext, schemaDef, snapshot);
            if (snapshot != null) {
                context.onBuildStarted();
            }
            OlapLoggers.BUILDER.debug((Object)("read tabular data [" + tabularData.getName() + "] process tables : [ " + tables.stream().map(t -> t.getName() + ":" + t.getDepth()).collect(Collectors.joining(", ")) + " ]"));
            OlapBuilderTableProcessingHelper.processTables(context, connectionPool, processingSchedulingPolicy, tables, null, tabularDataBrowsingInfo);
            boolean bl = tabularDataProcessor.reading;
            return bl;
        }
        finally {
            tabularData.removeListener(tabularDataProcessor);
        }
    }

    private static class TableListener
    extends OlapBuilderAbstractTableListener {
        @Nullable
        private final OlapBuilderBaseDataView view;
        private final Predicate<IOlapBuilderTableRow> visitor;
        private boolean reading;

        private TableListener(IOlapBuilderTabularDataDef tabularData, Predicate<IOlapBuilderTableRow> visitor) {
            this.view = tabularData instanceof OlapBuilderBaseDataView ? (OlapBuilderBaseDataView)tabularData : null;
            this.visitor = visitor;
        }

        @Override
        public boolean hasPostOrderListener(OlapBuilderViewCycleDetector cycleDetector) {
            return this.view != null && this.view.hasPostOrderListener(cycleDetector);
        }

        @Override
        public void onTableProcessingStarted(OlapBuilderContext context, IOlapBuilderTabularDataDef tabularData) {
            this.reading = true;
        }

        @Override
        public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow row) {
            if (context.isCancelling()) {
                this.reading = false;
                return false;
            }
            if (!this.visitor.test(row)) {
                this.reading = false;
                return false;
            }
            return true;
        }
    }

    private static class BuilderContext
    extends OlapBuilderContext {
        public BuilderContext(OlapEngineRequestContext requestContext, IOlapBuilderSchemaDef schemaDef, @Nullable String snapshot) {
            super(requestContext, new OlapEngineLoadSchemaParams(null, false, -1, -1, snapshot == null ? OlapEngineOfflineMode.OFF : OlapEngineOfflineMode.READ, snapshot, false), OlapBuilderContextMode.TABLE_PROCESSING, null, null, schemaDef);
        }
    }
}

