/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.errors;

import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.contextual.IOlapContextual;
import crazydev.iccube.olap.loggers.OlapLoggers;
import org.apache.log4j.Logger;

public abstract class OlapBuilderErrorManagerHelper {
    public static final Logger LOGGER = OlapLoggers.BUILDER;

    public static void performValidation(OlapBuilderErrorManager errorManager, Runnable task, IOlapContextual ... contextual) {
        int contextSize = 0;
        if (contextual != null) {
            for (IOlapContextual olapContextual : contextual) {
                if (olapContextual == null) continue;
                ++contextSize;
                errorManager.pushContext(olapContextual);
            }
        }
        try {
            task.run();
        }
        catch (OlapBuilderErrorException ex) {
            LOGGER.warn((Object)"validation builder-error-exception", (Throwable)((Object)ex));
            errorManager.addError(ex.getError());
            throw new RuntimeException("marker:validation builder-error-exception");
        }
        catch (RuntimeException ex) {
            errorManager.addException(ex);
            throw new RuntimeException("marker:validation runtime-exception");
        }
        finally {
            errorManager.popContext(contextSize);
        }
    }
}

