/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.spss.lib;

import crazydev.iccube.builder.datasource.spss.lib.SpssInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class ValueLabelsRecord {
    static final int RECORD_TYPE = 3;
    private final Map<Double, byte[]> labels = new HashMap<Double, byte[]>();

    ValueLabelsRecord(SpssInputStream inputStream) throws IOException {
        int count = inputStream.readInt();
        for (int i = 0; i < count; ++i) {
            this.labels.put(inputStream.readDouble(), this.readValueLabel(inputStream));
        }
    }

    private byte[] readValueLabel(SpssInputStream inputStream) throws IOException {
        int actualLength = inputStream.readUnsignedByte();
        int lengthWithPadding = this.calculateLengthInStream(actualLength);
        byte[] label = inputStream.readBytes(actualLength);
        inputStream.skipBytes(lengthWithPadding - actualLength);
        return label;
    }

    private int calculateLengthInStream(int length) {
        int mod = (length + 1) % 8;
        int aligned = length;
        if (mod != 0) {
            aligned += 8 - mod;
        }
        return aligned;
    }

    public Map<Double, byte[]> getLabels() {
        return this.labels;
    }
}

