/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.spss.lib;

import crazydev.iccube.builder.datasource.spss.lib.CaseBuffer;
import crazydev.iccube.builder.datasource.spss.lib.MissingValuesHeader;
import crazydev.iccube.builder.datasource.spss.lib.SpssInputStream;
import crazydev.iccube.builder.datasource.spss.lib.SpssVariable;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;

class CaseReader {
    protected final List<SpssVariable> variables;
    protected final SpssInputStream inputStream;
    protected final MissingValuesHeader missingValues;
    protected final CaseBuffer currentRow;
    protected final int numCases;
    protected int currentRowIndex;

    public CaseReader(SpssInputStream inputStream, List<SpssVariable> variables, MissingValuesHeader missingValues, int numCases, CaseBuffer currentRow) {
        this.inputStream = inputStream;
        this.variables = variables;
        this.missingValues = missingValues;
        this.currentRow = currentRow;
        this.numCases = numCases;
        this.currentRowIndex = -1;
        inputStream.getFile().mark(Integer.MAX_VALUE);
    }

    public final boolean readNext() throws IOException {
        if (this.numCases < 0) {
            try {
                this.readRow();
                return true;
            }
            catch (EOFException e) {
                return false;
            }
        }
        if (this.currentRowIndex + 1 < this.numCases) {
            this.readRow();
            ++this.currentRowIndex;
            return true;
        }
        return false;
    }

    protected void readRow() throws IOException {
        for (SpssVariable var : this.variables) {
            if (var.isNumeric()) {
                double value = this.inputStream.readDouble();
                if (value == this.missingValues.getSystemMissingValue()) {
                    this.currentRow.setMissing(var.getIndex());
                    continue;
                }
                this.currentRow.set(var.getIndex(), value);
                continue;
            }
            byte[] value = this.inputStream.readBytes(SpssInputStream.alignSize(var.stringLength, 8));
            this.currentRow.set(var.getIndex(), this.inputStream.stringFromBytes(value));
        }
    }

    public void restart() throws IOException {
        this.inputStream.getFile().reset();
        this.currentRowIndex = -1;
    }
}

