/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.spss;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdPair;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssMappersOptions;
import crazydev.iccube.builder.datasource.spss.lib.SpssDataFileReader;
import crazydev.iccube.builder.datasource.spss.lib.SpssVariable;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderSpssMappers {
    private final String tableName;

    protected OlapBuilderSpssMappers(String tableName) {
        this.tableName = tableName;
    }

    public static CdPair<List<OlapBuilderSpssMappers>, List<OlapBuilderSpssMappers>> builder(SpssDataFileReader reader, OlapBuilderSpssMappersOptions options) {
        String variableSeparator = options.variableSeparator;
        List<SpssVariable> variables = reader.getVariables();
        ArrayList<OlapBuilderSpssMappers> ret = new ArrayList<OlapBuilderSpssMappers>();
        ArrayList meas = new ArrayList();
        HashMap<String, List> variablesQuestions = new HashMap<String, List>();
        HashSet tableNames = new HashSet();
        variables.forEach(spssVariable -> {
            if (CdStringUtils.isNotNullAndNotBlank((String)variableSeparator) && spssVariable.getVariableName().contains(variableSeparator)) {
                String[] split = spssVariable.getVariableName().split(variableSeparator);
                variablesQuestions.computeIfAbsent(split[0], s -> new ArrayList()).add(spssVariable);
            } else if (spssVariable.getValueLabels().size() > 1) {
                OlapBuilderSpssSingleMappers map = new OlapBuilderSpssSingleMappers((SpssVariable)spssVariable);
                ret.add(map);
                tableNames.add(map.getTableName());
            } else {
                OlapBuilderSpssValue map = new OlapBuilderSpssValue((SpssVariable)spssVariable);
                meas.add(map);
                tableNames.add(map.getTableName());
            }
        });
        variablesQuestions.forEach((variableName, list) -> {
            if (list.size() == 1) {
                OlapBuilderSpssSingleMappers map = new OlapBuilderSpssSingleMappers((SpssVariable)list.get(0));
                ret.add(map);
                tableNames.add(map.getTableName());
            } else {
                if (tableNames.contains(variableName)) {
                    variableName = ((SpssVariable)list.get(0)).getIndex() + "::" + (String)variableName;
                }
                OlapBuilderSpssMappers.buildMultiple(options, ret, (String)variableName, list);
                tableNames.add(variableName);
            }
        });
        ret.sort(Comparator.comparingInt(OlapBuilderSpssMappers::getRank));
        return new CdPair(ret, meas);
    }

    private static void buildMultiple(OlapBuilderSpssMappersOptions options, List<OlapBuilderSpssMappers> mappers, String variableName, List<SpssVariable> list) {
        List refTable = list.stream().map(OlapBuilderSpssMappers::asRefTable).collect(Collectors.toList());
        boolean isOption = refTable.stream().noneMatch(cdPairs -> cdPairs.size() != 1);
        if (isOption) {
            mappers.add(new OlapBuilderSpssOptions(variableName, list));
        } else {
            boolean sameRef = false;
            if (sameRef) {
                list.forEach(spssVariable -> mappers.add(new OlapBuilderSpssRelabledMappers((SpssVariable)spssVariable, options.questionGroupLabelSeparator)));
            } else {
                mappers.add(new OlapBuilderSpssListQuestions(variableName, list));
            }
        }
    }

    protected static String getExistingVariableName(SpssVariable variable) {
        String variableLabel = variable.getVariableLabel();
        return CdStringUtils.isNotNullAndNotBlank((String)variableLabel) ? variableLabel : variable.getVariableName();
    }

    public abstract int getRank();

    public String getTableName() {
        return this.tableName;
    }

    public abstract String getDimensionName();

    protected boolean isDataArray() {
        return false;
    }

    @Nullable
    public abstract String getDescription();

    public abstract int size();

    protected static ArrayList<CdPair<Double, String>> asRefTable(SpssVariable variable) {
        ArrayList<CdPair<Double, String>> table = new ArrayList<CdPair<Double, String>>();
        variable.getValueLabels().forEach((key, value) -> table.add(new CdPair(key, value)));
        table.sort(Comparator.comparingDouble(o -> (Double)o.fst));
        return table;
    }

    public abstract List<OlapBuilderDataColumn> getColumns();

    public int getIndex() {
        return 0;
    }

    @Nullable
    public abstract Comparable<?> getValueForDataRow(SpssDataFileReader var1);

    protected abstract OlapBuilderInputType getKeyType();

    public abstract IOlapBuilderTableRow getRowForVariableRefData(int var1);

    public static OlapBuilderSpssMappers dataTable(List<OlapBuilderSpssMappers> tables, List<OlapBuilderSpssMappers> measureTables, String tableName, long size) {
        return new OlapBuilderSpssDataMappers(tableName, tables, measureTables, size);
    }

    public String getNameColumnName() {
        return "Description";
    }

    @Nullable
    public String getIntermediateLevelColumnName() {
        return null;
    }

    public String getKeyColumnName() {
        return "Key";
    }

    public abstract String getVariableName();

    public boolean hasAssociatedStats() {
        return false;
    }

    public void addToMdxScript(StringBuilder script, String hierName, String dimensionName) {
    }

    public String getMeasureName() {
        return this.getTableName();
    }

    private static class OlapBuilderSpssOptions
    extends OlapBuilderSpssMappers {
        private final String description;
        private final List<SpssVariable> variables;

        public OlapBuilderSpssOptions(String variableName, List<SpssVariable> variables) {
            super(variableName);
            this.description = OlapBuilderSpssOptions.getQuestion(variables.get(0));
            this.variables = variables;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getRank() {
            return this.variables.get(0).getIndex();
        }

        @Override
        public String getDimensionName() {
            return this.description;
        }

        @Override
        public String getVariableName() {
            return this.getTableName();
        }

        @Override
        public int size() {
            return this.variables.size();
        }

        @Override
        protected OlapBuilderInputType getKeyType() {
            return OlapBuilderInputType.STRING;
        }

        @Override
        public List<OlapBuilderDataColumn> getColumns() {
            return Arrays.asList(new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "Spss-Key", "Key"), new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "Spss-String", "Description"));
        }

        @Override
        public IOlapBuilderTableRow getRowForVariableRefData(int rowNb) {
            SpssVariable variable = this.variables.get(rowNb);
            return columnDef -> {
                if (columnDef.getIndex() == 0) {
                    return variable.getVariableName();
                }
                return OlapBuilderSpssOptions.getOption(variable);
            };
        }

        private static String getOption(SpssVariable variable) {
            return OlapBuilderSpssOptions.getExistingVariableName(variable).split(" - ")[0];
        }

        private static String getQuestion(SpssVariable variable) {
            String[] split = OlapBuilderSpssOptions.getExistingVariableName(variable).split(" - ");
            return split.length > 1 ? split[1] : split[0];
        }

        @Override
        protected boolean isDataArray() {
            return true;
        }

        @Override
        @Nullable
        public Comparable<?> getValueForDataRow(SpssDataFileReader reader) {
            List notEmpty = this.variables.stream().filter(spssVariable -> !reader.isSystemMissing(spssVariable.getIndex())).collect(Collectors.toList());
            if (notEmpty.isEmpty()) {
                return null;
            }
            List asValues = notEmpty.stream().map(SpssVariable::getVariableName).collect(Collectors.toList());
            return new CdComparableArray(asValues);
        }
    }

    private static class OlapBuilderSpssListQuestions
    extends OlapBuilderSpssMappers {
        private final String variableName;
        private final String description;
        private final List<SpssVariable> variables;
        private final List<ArrayList<CdPair<Double, String>>> refTables;
        private final ArrayList<CdPair<Integer, Integer>> rowToVariable = new ArrayList();

        public OlapBuilderSpssListQuestions(String variableName, List<SpssVariable> variables) {
            super(variableName);
            this.variableName = variableName;
            this.description = OlapBuilderSpssListQuestions.getQuestion(variables.get(0));
            this.variables = variables;
            this.refTables = variables.stream().map(OlapBuilderSpssMappers::asRefTable).collect(Collectors.toList());
            for (int variableNb = 0; variableNb < this.refTables.size(); ++variableNb) {
                ArrayList<CdPair<Double, String>> refTable = this.refTables.get(variableNb);
                for (int refTableNb = 0; refTableNb < refTable.size(); ++refTableNb) {
                    this.rowToVariable.add((CdPair<Integer, Integer>)new CdPair((Object)variableNb, (Object)refTableNb));
                }
            }
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getVariableName() {
            return this.variableName;
        }

        @Override
        public String getDimensionName() {
            return this.description;
        }

        @Override
        public String getIntermediateLevelColumnName() {
            return "Question";
        }

        @Override
        public String getNameColumnName() {
            return "Answer";
        }

        @Override
        public String getKeyColumnName() {
            return "Key";
        }

        @Override
        public int getRank() {
            return this.variables.get(0).getIndex();
        }

        @Override
        public int size() {
            return this.rowToVariable.size();
        }

        @Override
        protected OlapBuilderInputType getKeyType() {
            return OlapBuilderInputType.STRING;
        }

        @Override
        public List<OlapBuilderDataColumn> getColumns() {
            return Arrays.asList(new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "Spss-Key", "Key"), new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "Spss-String", "Question"), new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "Spss-String", "Answer"));
        }

        @Override
        public boolean hasAssociatedStats() {
            return true;
        }

        @Override
        public void addToMdxScript(StringBuilder script, String hierName, String dimensionName) {
            Map<Double, String> labels = this.variables.get(0).getValueLabels();
            List<CdPair> refTable = labels.keySet().stream().map(key -> new CdPair(key, (Object)((String)labels.get(key)))).sorted(Comparator.comparingDouble(o -> (Double)o.fst)).collect(Collectors.toList());
            script.append("\n\n");
            refTable.forEach(row -> script.append(" CREATE MEMBER ").append("[Stats].[").append(hierName).append("].default.[").append((String)row.snd).append("] AS StatsCalcFun([Stats].[" + hierName + "].currentMember, [" + dimensionName + "].[" + hierName + "])\n"));
        }

        @Override
        public IOlapBuilderTableRow getRowForVariableRefData(int rowNb) {
            int variableNb = (Integer)this.rowToVariable.get((int)rowNb).fst;
            int refTableNb = (Integer)this.rowToVariable.get((int)rowNb).snd;
            SpssVariable variable = this.variables.get(variableNb);
            CdPair<Double, String> refLine = this.refTables.get(variableNb).get(refTableNb);
            return columnDef -> {
                if (columnDef.getIndex() == 0) {
                    return this.asKey(variable, (Double)refLine.fst);
                }
                if (columnDef.getIndex() == 1) {
                    return OlapBuilderSpssListQuestions.getOption(variable);
                }
                return (Comparable)refLine.snd;
            };
        }

        private static String getOption(SpssVariable variable) {
            return OlapBuilderSpssListQuestions.getExistingVariableName(variable).split(" - ")[0];
        }

        private static String getQuestion(SpssVariable variable) {
            String[] split = OlapBuilderSpssListQuestions.getExistingVariableName(variable).split(" - ");
            return split.length > 1 ? split[1] : split[0];
        }

        @Override
        protected boolean isDataArray() {
            return true;
        }

        @Override
        @Nullable
        public Comparable<?> getValueForDataRow(SpssDataFileReader reader) {
            List notEmpty = this.variables.stream().filter(spssVariable -> !reader.isSystemMissing(spssVariable.getIndex())).collect(Collectors.toList());
            List asValues = notEmpty.stream().map(spssVariable -> {
                Double index = reader.getDoubleValue(spssVariable.getIndex());
                return this.asKey((SpssVariable)spssVariable, index);
            }).collect(Collectors.toList());
            return new CdComparableArray(asValues);
        }

        @NotNull
        private String asKey(SpssVariable variable, Double index) {
            return variable.getVariableName() + "::" + index;
        }
    }

    private static class OlapBuilderSpssDataMappers
    extends OlapBuilderSpssMappers {
        private final List<OlapBuilderSpssMappers> keyTables;
        private final List<OlapBuilderSpssMappers> measureTables;
        private final int size;

        public OlapBuilderSpssDataMappers(String tableName, List<OlapBuilderSpssMappers> keyTables, List<OlapBuilderSpssMappers> measureTables, long size) {
            super(tableName);
            this.keyTables = keyTables;
            this.measureTables = measureTables;
            this.size = (int)size;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.keyTables.stream().map(OlapBuilderSpssMappers::getDescription).collect(Collectors.joining(","));
        }

        @Override
        public String getDimensionName() {
            return this.getTableName();
        }

        @Override
        public String getVariableName() {
            throw new CdShouldNotBeHereProgrammingException();
        }

        @Override
        protected OlapBuilderInputType getKeyType() {
            throw new CdShouldNotBeHereProgrammingException();
        }

        @Override
        public int getRank() {
            return -1;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public String getKeyColumnName() {
            return this.getColumns().get(0).getName();
        }

        @Override
        public List<OlapBuilderDataColumn> getColumns() {
            List keys = this.keyTables.stream().map(table -> new OlapBuilderDataColumn(table.getKeyType(), "Spss-Dim", table.getTableName(), true, table.isDataArray())).collect(Collectors.toList());
            List values = this.measureTables.stream().map(table -> new OlapBuilderDataColumn(table.getKeyType(), "Spss-Value", table.getTableName())).collect(Collectors.toList());
            return Stream.of(keys, values).flatMap(Collection::stream).collect(Collectors.toList());
        }

        @Override
        @Nullable
        public Comparable<?> getValueForDataRow(SpssDataFileReader reader) {
            throw new CdShouldNotBeHereProgrammingException();
        }

        @Override
        public IOlapBuilderTableRow getRowForVariableRefData(int rowNb) {
            throw new CdShouldNotBeHereProgrammingException();
        }
    }

    private static class OlapBuilderSpssRelabledMappers
    extends OlapBuilderSpssSingleMappers {
        private final String questionGroupLabelSeparator;

        public OlapBuilderSpssRelabledMappers(SpssVariable variable, String questionGroupLabelSeparator) {
            super(variable);
            this.questionGroupLabelSeparator = questionGroupLabelSeparator;
        }

        @Override
        @Nullable
        public String getDescription() {
            String desc = super.getDescription();
            if (CdStringUtils.isNullOrBlank((String)this.questionGroupLabelSeparator)) {
                return desc;
            }
            return desc.split(this.questionGroupLabelSeparator)[0];
        }
    }

    private static class OlapBuilderSpssSingleMappers
    extends OlapBuilderSpssMappers {
        private final SpssVariable variable;
        private final ArrayList<CdPair<Double, String>> table;

        public OlapBuilderSpssSingleMappers(SpssVariable variable) {
            super(variable.getVariableName());
            this.variable = variable;
            this.table = OlapBuilderSpssSingleMappers.asRefTable(variable);
        }

        @Override
        public String getVariableName() {
            return this.variable.getVariableName();
        }

        @Override
        @Nullable
        public String getDescription() {
            return OlapBuilderSpssSingleMappers.getExistingVariableName(this.variable);
        }

        @Override
        public int getRank() {
            return this.variable.getIndex();
        }

        @Override
        public String getDimensionName() {
            return OlapBuilderSpssSingleMappers.getExistingVariableName(this.variable);
        }

        @Override
        protected OlapBuilderInputType getKeyType() {
            return OlapBuilderInputType.DOUBLE;
        }

        @Override
        public List<OlapBuilderDataColumn> getColumns() {
            return Arrays.asList(new OlapBuilderDataColumn(OlapBuilderInputType.DOUBLE, "Spss-Double", "Key"), new OlapBuilderDataColumn(OlapBuilderInputType.STRING, "Spss-String", "Description"));
        }

        @Override
        public int size() {
            return this.table.size();
        }

        @Override
        public IOlapBuilderTableRow getRowForVariableRefData(int rowNb) {
            return columnDef -> columnDef.getIndex() == 0 ? (Comparable)this.table.get((int)rowNb).fst : (Comparable)this.table.get((int)rowNb).snd;
        }

        @Override
        @Nullable
        public Comparable<?> getValueForDataRow(SpssDataFileReader reader) {
            int index = this.variable.getIndex();
            if (reader.isSystemMissing(index)) {
                return null;
            }
            return reader.getDoubleValue(index);
        }
    }

    private static class OlapBuilderSpssValue
    extends OlapBuilderSpssMappers {
        private final SpssVariable variable;

        public OlapBuilderSpssValue(SpssVariable variable) {
            super("V:" + variable.getVariableName());
            this.variable = variable;
        }

        @Override
        public String getMeasureName() {
            return this.getDescription();
        }

        @Override
        public String getKeyColumnName() {
            return this.getTableName();
        }

        @Override
        public String getDescription() {
            return OlapBuilderSpssValue.getExistingVariableName(this.variable);
        }

        @Override
        public int getRank() {
            return this.variable.getIndex();
        }

        @Override
        public String getDimensionName() {
            throw new CdShouldNotBeHereProgrammingException();
        }

        @Override
        public String getVariableName() {
            return this.variable.getVariableName();
        }

        @Override
        protected OlapBuilderInputType getKeyType() {
            return OlapBuilderInputType.DOUBLE;
        }

        @Override
        public List<OlapBuilderDataColumn> getColumns() {
            throw new CdShouldNotBeHereProgrammingException();
        }

        @Override
        public int size() {
            throw new CdShouldNotBeHereProgrammingException();
        }

        @Override
        public IOlapBuilderTableRow getRowForVariableRefData(int rowNb) {
            throw new CdShouldNotBeHereProgrammingException();
        }

        @Override
        @Nullable
        public Comparable<?> getValueForDataRow(SpssDataFileReader reader) {
            int index = this.variable.getIndex();
            if (reader.isSystemMissing(index)) {
                return null;
            }
            return reader.getDoubleValue(index);
        }
    }
}

