/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.spss;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssConnection;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssMappers;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssMappersOptions;
import crazydev.iccube.builder.datasource.spss.OlapBuilderSpssTable;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.ux.meta.datasource.UxImage;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="spssDS")
public class OlapBuilderSpssDataSource
extends OlapBuilderBaseDataSource<OlapBuilderSpssConnection> {
    public static final CdProperty FILE = new CdReadWriteProperty(OlapBuilderSpssDataSource.class, "fileName"){

        public Class<?> getTypeForDefaultEditor() {
            return File.class;
        }
    };
    public static final CdProperty ENCODING = new CdReadWriteProperty(OlapBuilderSpssDataSource.class, "encoding");
    public static final CdProperty QUESTION_GROUP_LABEL_SEPARATOR = new CdReadWriteProperty(OlapBuilderSpssDataSource.class, "questionGroupLabelSeparator");
    public static final CdProperty QUESTION_GROUP_VARIABLE_SEPARATOR = new CdReadWriteProperty(OlapBuilderSpssDataSource.class, "questionGroupVariableSeparator");
    public static final CdProperty USE_VARIABLE_AS_DIMENSIONNAME = new CdReadWriteProperty(OlapBuilderSpssDataSource.class, "useVariableAsDimensionName");
    public static final CdProperty CREATE_STATS = new CdReadWriteProperty(OlapBuilderSpssDataSource.class, "createStats");
    public static final CdProperty CLEAR_SCHEMA_ON_NEW = new CdReadWriteProperty(OlapBuilderSpssDataSource.class, "clearSchemaOnNew");
    @XmlAttribute(name="questionGroupVariableSeparator", required=true)
    private String questionGroupVariableSeparator = "_";
    @XmlAttribute(name="questionGroupLabelSeparator", required=true)
    private String questionGroupLabelSeparator = " - ";
    @XmlAttribute(name="useVariableAsDimensionName", required=true)
    private boolean useVariableAsDimensionName = true;
    @XmlAttribute(name="createStats", required=true)
    private boolean createStats = true;
    @XmlAttribute(name="clearSchemaOnNew", required=true)
    private boolean clearSchemaOnNew = true;
    @XmlAttribute(name="fileName", required=true)
    private String fileName;
    @XmlAttribute(name="encoding", required=true)
    private String encoding;
    @XmlTransient
    private List<OlapBuilderSpssMappers> cachedRefTable;
    @XmlTransient
    private String cachedFileName;

    protected OlapBuilderSpssDataSource() {
    }

    public OlapBuilderSpssDataSource(String name, String description) {
        this.setNameAndDescription(name, description);
    }

    public OlapBuilderSpssDataSource(File file) {
        this.fileName = file.getAbsolutePath();
        this.setNameAndDescription(file.getName(), "");
    }

    @Override
    @Nullable
    protected UxImage getUxTypeImage() {
        return new UxImage(this.getClass(), this.getClass().getSimpleName() + ".png");
    }

    public Charset getEncoding() {
        if (this.encoding == null) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(this.encoding);
    }

    @Override
    protected String getReportDataSourceType() {
        return "Spss";
    }

    @Override
    protected String getReportDataSourceTypeCaption() {
        return "Spss";
    }

    @Override
    public boolean isDiscoverTablesSupported() {
        return true;
    }

    @Override
    @Nullable
    public List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes() {
        return null;
    }

    @Override
    public OlapBuilderSpssConnection createConnection(OlapRuntimeContext context, boolean forceRefresh) {
        return new OlapBuilderSpssConnection(this);
    }

    @Override
    public List<String> discoverAllTablesNames(OlapBuilderSpssConnection openedConnection, boolean filterSystemSchemas, @Nullable String filter) {
        this.cachedRefTable = openedConnection.getRefTables();
        this.cachedFileName = this.fileName;
        return openedConnection.discoverAllTablesNames(filter);
    }

    @Override
    public OlapBuilderBaseDataTable<OlapBuilderSpssConnection> createEmptyDiscoverTable(String tableName) {
        StringBuilder description = new StringBuilder();
        if (this.cachedFileName != null && this.cachedFileName.equals(this.fileName)) {
            Optional<OlapBuilderSpssMappers> refTable = this.cachedRefTable.stream().filter(table -> tableName.equals(table.getTableName())).findFirst();
            refTable.ifPresent(table -> description.append(table.getDescription()));
        } else {
            this.cachedRefTable = null;
        }
        return new OlapBuilderSpssTable(tableName, description.toString());
    }

    public String getFileName() {
        return this.fileName;
    }

    public OlapBuilderSpssMappersOptions getMapperOptions() {
        return new OlapBuilderSpssMappersOptions(this.questionGroupVariableSeparator, this.questionGroupLabelSeparator, this.useVariableAsDimensionName, this.createStats, this.clearSchemaOnNew);
    }
}

