/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.reader.cache;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.datasource.reader.cache.OlapBuilderCacheTableHelper;
import crazydev.iccube.builder.datasource.reader.cache.OlapBuilderCacheTableRow;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineSerializer;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderCacheReadTableRowReader
extends OlapBuilderAbstractTableRowReader {
    private final File cacheTableDirectory;
    private final IOlapBuilderDataTableDef table;
    @Nullable
    private DataInputStream in;
    @Nullable
    private Map<String, Integer> positions;

    public OlapBuilderCacheReadTableRowReader(OlapBuilderContext context, File cacheTableDirectory, IOlapBuilderDataTableDef table) {
        super(context, null, -1, table, table.getName() + "-offline");
        this.cacheTableDirectory = cacheTableDirectory;
        this.table = table;
        Logger logger = context.getLoggers().builder();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[table-cache] setup a reading-from-cache reader for table [" + table.getName() + "]"));
        }
    }

    @Override
    public String getName() {
        return "cache-write";
    }

    @Override
    @Nullable
    public IOlapBuilderTablePartitionKey getPartitionKey() {
        return null;
    }

    @Override
    public IOlapBuilderDataTableDef<IOlapBuilderConnection> getTable() {
        return this.table;
    }

    @Override
    public void doInit() {
        this.createStream();
    }

    @Override
    public boolean isRowSafe() {
        return true;
    }

    @Override
    @Nullable
    public IOlapBuilderTableRow doNextRow() {
        IOlapBuilderTableRow row = this.readRow();
        return row;
    }

    @Override
    public void done() {
        this.closeStream();
    }

    private void createStream() {
        String filename = OlapBuilderCacheTableHelper.getFileName(this.getTable());
        File tableFile = new File(this.cacheTableDirectory, filename);
        if (!tableFile.exists()) {
            OlapLoggers.BUILDER.error((Object)("[table-cache] unexpected exiting table-cache for table [" + this.getTableName() + "]"));
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_CACHE_MISSING_FILE_ERROR, new Serializable[]{this.getTableName()});
        }
        try {
            this.in = new DataInputStream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(tableFile))));
            this.positions = new HashMap<String, Integer>();
            int colCount = this.in.readInt();
            for (int ii = 0; ii < colCount; ++ii) {
                String colName = this.in.readUTF();
                this.positions.put(colName, ii);
            }
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)("[table-cache] could not create table-cache for table [" + this.getTableName() + "]"), (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_CACHE_CREATE_FILE_ERROR, new Serializable[]{this.getTableName(), ex.getMessage()});
        }
    }

    @Nullable
    private IOlapBuilderTableRow readRow() {
        if (this.in == null || this.positions == null) {
            return null;
        }
        try {
            int count = this.positions.size();
            Comparable[] values = new Comparable[count];
            for (int idx = 0; idx < count; ++idx) {
                byte type = this.in.readByte();
                OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForType(type);
                values[idx] = serializer.read(this.in);
            }
            return new OlapBuilderCacheTableRow(this.positions, values);
        }
        catch (EOFException ex) {
            return null;
        }
        catch (IOException ex) {
            OlapLoggers.BUILDER.error((Object)("[table-cache] could not read from the table-cache for table [" + this.getTableName() + "] [row:" + this.rowNumberForEndUser() + "]"), (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_CACHE_READ_ERROR, new Serializable[]{this.getTableName(), ex.getMessage()});
        }
    }

    private void closeStream() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException ex) {
                OlapLoggers.BUILDER.error((Object)("[table-cache] could not properly close the table-cache for table [" + this.getTableName() + "]"), (Throwable)ex);
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.TABLE_CACHE_CLOSE_FILE_ERROR, new Serializable[]{this.getTableName(), ex.getMessage()});
            }
        }
    }
}

