/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.reader;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;

@FunctionalInterface
public interface OlapBuilderLocalDateTimeReader {
    public org.joda.time.LocalDateTime parse(String var1) throws ParseException;

    public static OlapBuilderLocalDateTimeReader of(@Nullable Locale locale, String format) {
        if (format.equalsIgnoreCase("epoch")) {
            return value -> {
                try {
                    return new org.joda.time.LocalDateTime((long)(Double.parseDouble(value) * 1000.0), DateTimeZone.UTC);
                }
                catch (NumberFormatException ex) {
                    throw new ParseException(ex.getMessage(), 0);
                }
            };
        }
        if (format.equalsIgnoreCase("epoch_ms")) {
            return value -> {
                try {
                    return new org.joda.time.LocalDateTime((long)Double.parseDouble(value), DateTimeZone.UTC);
                }
                catch (NumberFormatException ex) {
                    throw new ParseException(ex.getMessage(), 0);
                }
            };
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format, locale);
        return value -> {
            LocalDateTime d = LocalDateTime.parse(value, df);
            return new org.joda.time.LocalDateTime(d.getYear(), d.getMonthValue(), d.getDayOfMonth(), d.getHour(), d.getMinute(), d.getSecond(), d.getNano() / 1000000);
        };
    }
}

