/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.reader;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTimeZone;

@FunctionalInterface
public interface OlapBuilderLocalDateReader {
    public static final TimeZone TZ = TimeZone.getTimeZone("UTC");

    public org.joda.time.LocalDate parse(String var1) throws ParseException;

    public static OlapBuilderLocalDateReader of(@Nullable Locale locale, String format) {
        if (format.equalsIgnoreCase("epoch")) {
            return value -> {
                try {
                    return new org.joda.time.LocalDate((long)(Double.parseDouble(value) * 1000.0), DateTimeZone.UTC);
                }
                catch (NumberFormatException ex) {
                    throw new ParseException(ex.getMessage(), 0);
                }
            };
        }
        if (format.equalsIgnoreCase("epoch_ms")) {
            return value -> {
                try {
                    return new org.joda.time.LocalDate((long)Double.parseDouble(value), DateTimeZone.UTC);
                }
                catch (NumberFormatException ex) {
                    throw new ParseException(ex.getMessage(), 0);
                }
            };
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format, locale);
        return value -> {
            LocalDate d = LocalDate.parse(value, df);
            return new org.joda.time.LocalDate(d.getYear(), d.getMonthValue(), d.getDayOfMonth());
        };
    }
}

