/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.memory;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdBufferedLineReader;
import crazydev.common.utils.CdLineReader;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.common.IOlapBuilderLineReaderTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderLineDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderLineScanner;
import crazydev.iccube.builder.datasource.file.OlapBuilderReaderLineScanner;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryConnection;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryDataSource;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderError;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.goodies.headerdef.column.OlapBuilderColumnsDefinitionParser;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="memoryDataTable")
public class OlapBuilderInMemoryLineDataTable
extends OlapBuilderLineDataTable<OlapBuilderInMemoryConnection>
implements IOlapBuilderLineReaderTable {
    public static final CdProperty DATA_AS_STRING = new CdReadWriteProperty(OlapBuilderInMemoryLineDataTable.class, "dataAsString");
    public static final String DEFAULT_COLUMN_SEPARATOR = "\t";
    public static final String DEFAULT_COMMENT_MARKER = "#";
    @XmlElement(required=true)
    private String dataAsString;

    public OlapBuilderInMemoryLineDataTable() {
    }

    private OlapBuilderInMemoryLineDataTable(String tableName, String dataAsString, String columnSeparator, String commentMarker, boolean withHeader) {
        super(tableName, columnSeparator, commentMarker, withHeader);
        this.dataAsString = dataAsString;
        if (withHeader) {
            OlapRuntimeContext rContext = null;
            OlapBuilderLineScanner scanner = this.createLineScanner((OlapBuilderInMemoryConnection)null, this.createLineReader(rContext, (OlapBuilderInMemoryConnection)null));
            String[] headerNames = scanner.nextLine();
            if (headerNames == null) {
                throw new OlapBuilderErrorException(new OlapBuilderError(OlapBuilderErrorCode.EMPTY_HEADER, new Serializable[]{this.getName()}));
            }
            this.buildColumnFromHeaderLine(headerNames);
        }
    }

    public OlapBuilderInMemoryLineDataTable(String tableName) {
        super(tableName);
    }

    public static OlapBuilderInMemoryLineDataTable __create(String tableName, String data) {
        String dsName = tableName + "-DS";
        OlapBuilderInMemoryDataSource ds = new OlapBuilderInMemoryDataSource(dsName);
        return OlapBuilderInMemoryLineDataTable.__create(ds, tableName, data);
    }

    public static OlapBuilderInMemoryLineDataTable __create(OlapBuilderInMemoryDataSource ds, String tableName, String data) {
        return OlapBuilderInMemoryLineDataTable.__create(ds, tableName, data, DEFAULT_COLUMN_SEPARATOR);
    }

    public static OlapBuilderInMemoryLineDataTable __create(OlapBuilderInMemoryDataSource ds, String tableName, String data, String colSep) {
        OlapBuilderInMemoryLineDataTable dt = new OlapBuilderInMemoryLineDataTable(tableName, data, colSep, DEFAULT_COMMENT_MARKER, true);
        ds.link(dt);
        return dt;
    }

    public static OlapBuilderInMemoryLineDataTable __createWithColumns(String dsName, String tableName, String data, String columnSeparator, List<IOlapBuilderDataColumnDef> columns) {
        OlapBuilderInMemoryDataSource ds = new OlapBuilderInMemoryDataSource(dsName);
        return OlapBuilderInMemoryLineDataTable.__createWithColumns(ds, tableName, data, columnSeparator, columns);
    }

    public static OlapBuilderInMemoryLineDataTable __createWithColumns(OlapBuilderInMemoryDataSource ds, String tableName, String data, String columnSeparator, List<IOlapBuilderDataColumnDef> columns) {
        OlapBuilderInMemoryLineDataTable table = new OlapBuilderInMemoryLineDataTable(tableName, data, columnSeparator, DEFAULT_COMMENT_MARKER, false);
        for (IOlapBuilderDataColumnDef column : columns) {
            table.addColumn(column);
        }
        ds.link(table);
        return table;
    }

    @Override
    public String getInternalFriendlyTypeName() {
        return "In Memory Table";
    }

    @Override
    public boolean isNameReadOnly() {
        return false;
    }

    protected void buildColumnFromHeaderLine(String[] headerNames) {
        this.resetColumns(OlapBuilderColumnsDefinitionParser.parse(headerNames, this.addRowNumber));
    }

    @Override
    protected String getFullNameForEndUser(OlapRuntimeContext context, OlapBuilderInMemoryConnection connection) {
        return this.getName();
    }

    @Override
    public OlapBuilderLineScanner createLineScanner(OlapBuilderInMemoryConnection openedConnection, CdLineReader lineReader) {
        return new OlapBuilderReaderLineScanner(this.getName(), lineReader, this.getCommentMarker(), this.getColumnSeparator());
    }

    @Override
    public CdLineReader createLineReader(OlapRuntimeContext context__, OlapBuilderInMemoryConnection openedConnection) {
        BufferedReader stringReader = new BufferedReader(new StringReader(this.dataAsString));
        CdBufferedLineReader lineReader = new CdBufferedLineReader(stringReader, this.getName());
        return lineReader;
    }

    public String getDataAsString() {
        return this.dataAsString;
    }

    public void setDataAsString(String dataAsString) {
        this.dataAsString = dataAsString;
    }

    @Override
    @Nullable
    protected IOlapBuilderTableRowReader createRowReaderForTableCacheRead(OlapBuilderContext context) {
        return null;
    }

    @Override
    protected IOlapBuilderTableRowReader decorateRowReaderForTableCache(OlapBuilderContext context, IOlapBuilderTableRowReader reader) {
        return reader;
    }

    @Override
    protected IOlapBuilderTableRowReader decorateRowReaderForBackup(OlapBuilderContext context, IOlapBuilderTableRowReader reader, boolean tablePartition) {
        return reader;
    }

    @Override
    @Nullable
    protected IOlapBuilderTableRowReader createRowReaderForRestore(OlapBuilderContext context, boolean tablePartition) {
        return null;
    }

    @Override
    protected IOlapBuilderTableRowReader decorateRowReaderForOfflineWrite(OlapBuilderContext context, IOlapBuilderTableRowReader reader) {
        return reader;
    }

    @Override
    protected IOlapBuilderTableRowReader createRowReaderForOfflineRead(OlapBuilderContext context, @Nullable IOlapBuilderTablePartitionKey partitionKey) {
        return null;
    }

    @Override
    public boolean checkColumnSize() {
        return true;
    }
}

