/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.memory;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryConnection;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="directBufferDataTable")
public final class OlapBuilderInMemoryDirectBufferDataTable
extends OlapBuilderBaseDataTable<OlapBuilderInMemoryConnection> {
    @XmlAttribute(name="rowSize", required=true)
    private int rowSize;
    @XmlAttribute(name="colSize", required=true)
    private int colSize;
    @XmlTransient
    private Comparable[] buffer;

    public OlapBuilderInMemoryDirectBufferDataTable() {
    }

    public OlapBuilderInMemoryDirectBufferDataTable(String tableName, int rowSize, IOlapBuilderDataColumnDef ... columns) {
        super(tableName, Arrays.asList(columns));
        this.rowSize = rowSize;
        this.colSize = columns.length;
        this.buffer = new Comparable[rowSize * this.colSize];
    }

    @Override
    public boolean notCacheInIncrementalLoad() {
        return true;
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderInMemoryConnection openedConnection, OlapBuilderErrorManager errorManager) {
        return this.getAllColumns();
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderInMemoryConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new MyRowReader(this, context, connectionPool, maxRowCount, this);
    }

    @Override
    public String getInternalFriendlyTypeName() {
        return "In Memory Direct Buffer Table";
    }

    private final class MyRowReader
    extends OlapBuilderAbstractTableRowReader<OlapBuilderInMemoryDirectBufferDataTable, OlapBuilderInMemoryConnection> {
        int currentRow;
        final /* synthetic */ OlapBuilderInMemoryDirectBufferDataTable this$0;

        private MyRowReader(OlapBuilderInMemoryDirectBufferDataTable olapBuilderInMemoryDirectBufferDataTable, OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderInMemoryDirectBufferDataTable table) {
            OlapBuilderInMemoryDirectBufferDataTable olapBuilderInMemoryDirectBufferDataTable2 = olapBuilderInMemoryDirectBufferDataTable;
            Objects.requireNonNull(olapBuilderInMemoryDirectBufferDataTable2);
            this.this$0 = olapBuilderInMemoryDirectBufferDataTable2;
            super(context, connectionPool, maxRowCount, table, table.getName());
        }

        @Override
        protected int numberOfHeaderRows() {
            return 1;
        }

        @Override
        public void doInit() {
            this.currentRow = 0;
        }

        @Override
        public boolean isRowSafe() {
            return true;
        }

        @Override
        @Nullable
        public IOlapBuilderTableRow doNextRow() {
            if (this.currentRow >= this.this$0.rowSize) {
                return null;
            }
            return new MyRow(this.this$0, this.currentRow++);
        }

        @Override
        public void done() {
            super.done();
        }
    }

    private final class MyRow
    implements IOlapBuilderTableRow {
        private final int initialPos;
        final /* synthetic */ OlapBuilderInMemoryDirectBufferDataTable this$0;

        public MyRow(OlapBuilderInMemoryDirectBufferDataTable olapBuilderInMemoryDirectBufferDataTable, int currentRow) {
            OlapBuilderInMemoryDirectBufferDataTable olapBuilderInMemoryDirectBufferDataTable2 = olapBuilderInMemoryDirectBufferDataTable;
            Objects.requireNonNull(olapBuilderInMemoryDirectBufferDataTable2);
            this.this$0 = olapBuilderInMemoryDirectBufferDataTable2;
            this.initialPos = currentRow * olapBuilderInMemoryDirectBufferDataTable.colSize;
        }

        @Override
        @Nullable
        public Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef) {
            return this.this$0.buffer[this.initialPos + columnDef.getIndex()];
        }
    }
}

