/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.memory;

import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryConnection;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryLineDataTable;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateDataSourceWizardSteps;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateTypedDataSourceWizard;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderDataSourceNameForm;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="inMemoryDS")
public class OlapBuilderInMemoryDataSource
extends OlapBuilderBaseDataSource<OlapBuilderInMemoryConnection> {
    static final List<Class<? extends IOlapBuilderTabularDataDef>> CREATED_TABLE_TYPES = Arrays.asList(OlapBuilderInMemoryLineDataTable.class);

    public OlapBuilderInMemoryDataSource() {
    }

    public OlapBuilderInMemoryDataSource(String name) {
        super(name);
    }

    public OlapBuilderInMemoryDataSource(String name, @Nullable String description) {
        super(name, description);
    }

    @Override
    public OlapBuilderBaseDataTable<OlapBuilderInMemoryConnection> createEmptyCreateTable(@Nullable Class<IOlapBuilderTabularDataDef> tableType) {
        return new OlapBuilderInMemoryLineDataTable("");
    }

    @Override
    protected String getReportDataSourceType() {
        return "inMemory";
    }

    @Override
    protected String getReportDataSourceTypeCaption() {
        return "In Memory";
    }

    @Override
    public boolean isDiscoverTablesSupported() {
        return false;
    }

    @Override
    @Nullable
    public List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes() {
        return CREATED_TABLE_TYPES;
    }

    @Override
    public OlapBuilderInMemoryConnection createConnection(OlapRuntimeContext context, boolean forceRefresh) {
        return new OlapBuilderInMemoryConnection(this);
    }

    @Override
    public boolean acceptCachedTable() {
        return false;
    }

    @Override
    public boolean hasNoTyping() {
        return true;
    }

    @Override
    protected UxBuilderDataSourceType createUxType() {
        String id = this.getTypeId();
        return new UxBuilderDataSourceType(id, this.getUxTypeImage(), () -> new UxBuilderCreateTypedDataSourceWizard(this, id, this.createUxCreateWizardSteps()){
            {
                Objects.requireNonNull(this$0);
                super(dataSourceTypeId, steps);
            }

            @Override
            public IOlapBuilderDataSource getDataSourceFromUI() {
                UxBuilderDataSourceNameForm name = (UxBuilderDataSourceNameForm)((UxBuilderWizardStep)this.steps.get(0)).getModel();
                return new OlapBuilderInMemoryDataSource(name.getName(), name.getDescription());
            }
        });
    }

    @Override
    protected List<UxBuilderWizardStep> createUxCreateWizardSteps() {
        ArrayList<UxBuilderWizardStep> steps = new ArrayList<UxBuilderWizardStep>();
        steps.add(UxBuilderCreateDataSourceWizardSteps.name());
        return steps;
    }
}

