/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.memory;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryConnection;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="inMemoryBufferDataTable")
public final class OlapBuilderInMemoryBufferDataTable
extends OlapBuilderBaseDataTable<OlapBuilderInMemoryConnection> {
    @XmlTransient
    private final List<Comparable[]> buffer = new ArrayList<Comparable[]>();

    public OlapBuilderInMemoryBufferDataTable() {
    }

    public OlapBuilderInMemoryBufferDataTable(String tableName, IOlapBuilderDataColumnDef ... columns) {
        super(tableName, Arrays.asList(columns));
    }

    public void resetData() {
        this.buffer.clear();
    }

    public void addRow(Comparable[] values) {
        this.buffer.add(values);
    }

    @Override
    public boolean notCacheInIncrementalLoad() {
        return true;
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderInMemoryConnection openedConnection, OlapBuilderErrorManager errorManager) {
        return this.getAllColumns();
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderInMemoryConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new MyRowReader(this, context, connectionPool, maxRowCount, this);
    }

    @Override
    public String getInternalFriendlyTypeName() {
        return "In Memory Buffer Table";
    }

    private final class MyRowReader
    extends OlapBuilderAbstractTableRowReader<OlapBuilderInMemoryBufferDataTable, OlapBuilderInMemoryConnection> {
        int currentRow;
        final /* synthetic */ OlapBuilderInMemoryBufferDataTable this$0;

        private MyRowReader(OlapBuilderInMemoryBufferDataTable olapBuilderInMemoryBufferDataTable, OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderInMemoryBufferDataTable table) {
            OlapBuilderInMemoryBufferDataTable olapBuilderInMemoryBufferDataTable2 = olapBuilderInMemoryBufferDataTable;
            Objects.requireNonNull(olapBuilderInMemoryBufferDataTable2);
            this.this$0 = olapBuilderInMemoryBufferDataTable2;
            super(context, connectionPool, maxRowCount, table, table.getName());
        }

        @Override
        protected int numberOfHeaderRows() {
            return 1;
        }

        @Override
        public void doInit() {
            this.currentRow = 0;
        }

        @Override
        public boolean isRowSafe() {
            return true;
        }

        @Override
        @Nullable
        public IOlapBuilderTableRow doNextRow() {
            if (this.currentRow >= this.this$0.buffer.size()) {
                return null;
            }
            return new MyRow(this.this$0, this.this$0.buffer.get(this.currentRow++));
        }

        @Override
        public void done() {
            super.done();
        }
    }

    private final class MyRow
    implements IOlapBuilderTableRow {
        private final Comparable[] data;

        public MyRow(OlapBuilderInMemoryBufferDataTable olapBuilderInMemoryBufferDataTable, Comparable[] data) {
            Objects.requireNonNull(olapBuilderInMemoryBufferDataTable);
            this.data = data;
        }

        @Override
        @Nullable
        public Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef) {
            return this.data[columnDef.getIndex()];
        }
    }
}

