/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.json.base;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.json.base.IOlapBuilderJsonConnection;
import crazydev.iccube.builder.datasource.json.base.IOlapBuilderJsonDataTable;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.gson.GsonTableReader;
import crazydev.iccube.gson.GsonUtils;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderJsonTableRowReader<T extends IOlapBuilderJsonDataTable<C>, C extends IOlapBuilderJsonConnection>
extends OlapBuilderAbstractTableRowReader<T, C> {
    Supplier<JsonReader> readerProvider = null;
    private GsonTableReader bsonReader;
    private JsonReader reader;

    public OlapBuilderJsonTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, T table, String fullNameForEndUser) {
        super(context, connectionPool, maxRowCount, table, fullNameForEndUser);
    }

    @Override
    public void doInit() {
        this.initConnection();
        this.bsonReader = new GsonTableReader(((IOlapBuilderJsonDataTable)this.table).getSelectedColumns());
        this.readerProvider = this.executeRequest(this.context.asRuntimeContext());
    }

    public Supplier<JsonReader> executeRequest(OlapRuntimeContext context) {
        return ((IOlapBuilderJsonDataTable)this.table).executeRequest(context, (IOlapBuilderJsonConnection)this.connection, -1);
    }

    @Override
    public boolean isRowSafe() {
        return true;
    }

    @Override
    @Nullable
    public IOlapBuilderTableRow doNextRow() {
        try {
            IOlapBuilderTableRow row;
            if (this.reader == null) {
                this.reader = this.readerProvider.get();
                if (this.reader == null) {
                    return null;
                }
                GsonUtils.advanceStream(this.reader, ((IOlapBuilderJsonDataTable)this.table).getDocRoot(), ((IOlapBuilderJsonDataTable)this.table)::tagMatchesError);
                this.bsonReader.init(this.reader);
            }
            if ((row = this.bsonReader.nextRow()) == null) {
                this.reader.close();
                this.reader = null;
                return this.doNextRow();
            }
            return row;
        }
        catch (MalformedJsonException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.MALFORMED_JSON_EXCEPTION, new Serializable[]{ex.getMessage()});
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, ex);
        }
    }
}

