/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc.ux;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdXmlParametersUtils;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSourceException;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="jdbcDSsqlAnywhere")
public class UxBuilderSqlAnywhereJdbcDataSource
extends OlapBuilderJdbcDataSource {
    public static final CdProperty HOST = new CdReadWriteProperty(UxBuilderSqlAnywhereJdbcDataSource.class, "host");
    @XmlAttribute
    private String host;

    public UxBuilderSqlAnywhereJdbcDataSource() {
        super(OlapBuilderDriverType.SQLANYWHERE);
    }

    public UxBuilderSqlAnywhereJdbcDataSource(UxBuilderSqlAnywhereJdbcDataSource dataSource) {
        super(dataSource, OlapBuilderDriverType.SQLANYWHERE);
        this.host = dataSource.host;
    }

    @Override
    @Nullable
    protected List<UxBuilderDataSourceType> createUxTypes() {
        return null;
    }

    @Override
    protected OlapBuilderBaseDataSource createEmptyDataSource() {
        return new UxBuilderSqlAnywhereJdbcDataSource();
    }

    @Override
    public OlapBuilderJdbcDataSource toUxEdition() {
        return new UxBuilderSqlAnywhereJdbcDataSource(this);
    }

    @Override
    public OlapBuilderJdbcDataSource fromUxEdition() {
        return new UxBuilderSqlAnywhereJdbcDataSource(this);
    }

    @Override
    protected void overrideParams(Properties params) {
        String dbName;
        String serverName;
        String serverNameEx;
        super.overrideParams(params);
        String hostEx = CdXmlParametersUtils.replace((String)this.host);
        if (CdStringUtils.isNotNullAndNotBlank((String)hostEx)) {
            params.put("Host", hostEx);
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)(serverNameEx = CdXmlParametersUtils.replace((String)(serverName = this.getServerName()))))) {
            params.put("ServerName", serverNameEx);
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)(dbName = this.getDbNameEx()))) {
            params.put("DatabaseName", dbName);
        }
    }

    @Override
    public void assertJdbcDriver() throws OlapBuilderJdbcDataSourceException {
        try {
            Class.forName("sap.jdbc4.sqlanywhere.IDriver");
        }
        catch (ClassNotFoundException ex) {
            throw new OlapBuilderJdbcDataSourceException("dataSourceTestConnectionMissingSqlAnywhere");
        }
    }
}

