/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc.ux;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdXmlParametersUtils;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSourceException;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="jdbcDSsnowflake")
public class UxBuilderSnowflakeJdbcDataSource
extends OlapBuilderJdbcDataSource {
    public static final CdProperty WAREHOUSE = new CdReadWriteProperty(UxBuilderSnowflakeJdbcDataSource.class, "warehouse");
    @XmlAttribute(required=false)
    private String warehouse;

    public UxBuilderSnowflakeJdbcDataSource() {
        super(OlapBuilderDriverType.SNOWFLAKE);
    }

    public UxBuilderSnowflakeJdbcDataSource(UxBuilderSnowflakeJdbcDataSource dataSource) {
        super(dataSource, OlapBuilderDriverType.SNOWFLAKE);
        this.warehouse = dataSource.warehouse;
    }

    @Override
    @Nullable
    protected List<UxBuilderDataSourceType> createUxTypes() {
        return null;
    }

    @Override
    protected OlapBuilderBaseDataSource createEmptyDataSource() {
        return new UxBuilderSnowflakeJdbcDataSource();
    }

    @Override
    public OlapBuilderJdbcDataSource toUxEdition() {
        return new UxBuilderSnowflakeJdbcDataSource(this);
    }

    @Override
    public OlapBuilderJdbcDataSource fromUxEdition() {
        return new UxBuilderSnowflakeJdbcDataSource(this);
    }

    @Override
    protected void overrideParams(Properties params) {
        super.overrideParams(params);
        String warehouseEx = CdXmlParametersUtils.replace((String)this.warehouse);
        if (CdStringUtils.isNotNullAndNotBlank((String)warehouseEx)) {
            params.put("warehouse", warehouseEx);
        }
    }

    @Override
    public void assertJdbcDriver() throws OlapBuilderJdbcDataSourceException {
        try {
            Class.forName("net.snowflake.client.jdbc.SnowflakeDriver");
        }
        catch (ClassNotFoundException ex) {
            throw new OlapBuilderJdbcDataSourceException("dataSourceTestConnectionMissingSnowflake");
        }
    }
}

