/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc.typed;

import crazydev.iccube.builder.datasource.jdbc.IBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcTypedDatasource;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderJdbcSqlServerLikeTypedDatasource
extends OlapBuilderJdbcTypedDatasource {
    public OlapBuilderJdbcSqlServerLikeTypedDatasource(OlapBuilderDriverType driverType, String dbName, String schemaName) {
        super(driverType, dbName, schemaName, "sys;information_schema");
    }

    @Override
    protected String getCatalogName() {
        return this.dbName;
    }

    @Override
    public ResultSet getDbTables(DatabaseMetaData metaData, @Nullable String tableNamePattern) throws SQLException {
        String catalogName = this.getCatalogName();
        String schemaName = this.getSchemaNameForMetaRetrieval();
        if (tableNamePattern != null && tableNamePattern.contains(".")) {
            int dotPos = tableNamePattern.indexOf(".");
            schemaName = tableNamePattern.substring(0, dotPos);
            tableNamePattern = tableNamePattern.substring(dotPos + 1);
        }
        String[] types = this.getTableTypes();
        ResultSet rs = metaData.getTables(catalogName, schemaName, tableNamePattern, types);
        return rs;
    }

    @Override
    public ResultSet getDbColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        String catalogName = this.getCatalogName();
        String schemaName = this.getSchemaNameForMetaRetrieval();
        if (tableName != null && tableName.contains(".")) {
            int dotPos = tableName.indexOf(".");
            schemaName = tableName.substring(0, dotPos);
            tableName = tableName.substring(dotPos + 1);
        }
        ResultSet rs = metaData.getColumns(catalogName, schemaName, tableName, null);
        return rs;
    }

    @Override
    public String getTableNameForCreateTable(DatabaseMetaData meta, @Nullable String tableCatalog, @Nullable String tableSchema, String tableName) throws SQLException {
        if (tableSchema != null && !tableSchema.isEmpty()) {
            return tableSchema + this.getCatalogSeparator(meta) + tableName;
        }
        return tableName;
    }

    protected String getCatalogSeparator(DatabaseMetaData meta) throws SQLException {
        return meta.getCatalogSeparator();
    }

    @Override
    public void onResultSetMetaData(IBuilderJdbcConnection openedConnection, String sqlStatement, OlapBuilderJdbcTypedDatasource.GetMetaDataProcessor processor) throws SQLException {
        this.doGetMetaData(openedConnection, sqlStatement, processor, false);
    }
}

