/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc.typed;

import crazydev.common.utils.CdJdbcUtils;
import crazydev.iccube.builder.datasource.jdbc.IBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcTypedDatasource;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class OlapBuilderJdbcMySQLTypedDatasource
extends OlapBuilderJdbcTypedDatasource {
    public OlapBuilderJdbcMySQLTypedDatasource(OlapBuilderDriverType driverType, String dbName, String schemaName) {
        super(driverType, dbName, schemaName);
    }

    @Override
    protected String getCatalogName() {
        return this.dbName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResultSetMetaData(IBuilderJdbcConnection openedConnection, String sqlStatement, OlapBuilderJdbcTypedDatasource.GetMetaDataProcessor processor) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = openedConnection.createStatement(sqlStatement, 1);
            ResultSetMetaData meta = stmt.getMetaData();
            if (meta == null) {
                stmt.setMaxRows(1);
                rs = stmt.executeQuery();
                meta = rs.getMetaData();
            }
            processor.onValid(meta);
        }
        finally {
            CdJdbcUtils.closeQuietly(rs);
            CdJdbcUtils.closeQuietly((Statement)stmt);
        }
    }

    protected boolean isUsingBackticks() {
        return true;
    }

    @Override
    public String getEntityNameForSqlStatement(DatabaseMetaData meta, String name, boolean isTable) throws SQLException {
        if (!this.isUsingBackticks()) {
            return super.getEntityNameForSqlStatement(meta, name, isTable);
        }
        String quoteString = meta.getIdentifierQuoteString();
        if (name.contains(quoteString)) {
            return name;
        }
        return quoteString + name + quoteString;
    }
}

