/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdJdbcUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableRequestedPartitionKeys;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderBaseJdbcDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcUnionDataTablePartitionRowReader;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcUnionTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderJdbcUnionDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="jdbcUnion")
public class OlapBuilderJdbcUnionDataTable
extends OlapBuilderBaseJdbcDataTable {
    public static final String DEFAULT_PARTITION = "SELECT $COLUMNS$ FROM $PARTITION$";
    public static final CdProperty PARTITIONS_SQL = new CdReadWriteProperty(OlapBuilderJdbcUnionDataTable.class, "partitionsSql");
    public static final CdProperty COLUMNS_SQL = new CdReadWriteProperty(OlapBuilderJdbcUnionDataTable.class, "columnsSql");
    public static final CdProperty PARTITION_SQL = new CdReadWriteProperty(OlapBuilderJdbcUnionDataTable.class, "partitionSql");
    @XmlElement(name="partitionsSql", required=true)
    private String partitionsSql;
    @XmlElement(name="partitionSql", required=false)
    @Nullable
    private String partitionSql;
    @XmlElement(name="columnsSql", required=false)
    @Nullable
    private String columnsSql;

    public OlapBuilderJdbcUnionDataTable() {
    }

    public OlapBuilderJdbcUnionDataTable(int defaultFetchSize) {
        super(defaultFetchSize);
    }

    @Override
    public boolean isNameReadOnly() {
        return false;
    }

    @Override
    public String getInternalFriendlyTypeName() {
        return "JDBC Union";
    }

    @Override
    public boolean isDiscoveredInDataSource() {
        return false;
    }

    @Override
    public boolean canCleanupNotUsedColumns() {
        return true;
    }

    @Override
    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable) {
        if (super.isRefreshColumnOnUpdate(newTable)) {
            return true;
        }
        OlapBuilderJdbcUnionDataTable tableUpdate = (OlapBuilderJdbcUnionDataTable)newTable;
        return !Objects.equals(this.partitionsSql, tableUpdate.partitionsSql) || !Objects.equals(this.columnsSql, tableUpdate.columnsSql) || !Objects.equals(this.partitionSql, tableUpdate.partitionSql);
    }

    @Override
    public boolean hasTablePartitioning() {
        return true;
    }

    public String getPartitionsSql() {
        return this.partitionsSql;
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderJdbcConnection openedConnection, OlapBuilderErrorManager errorManager) throws Exception {
        String tableName;
        if (CdStringUtils.isNotNullAndNotBlank((String)this.columnsSql)) {
            tableName = this.columnsSql;
            if (OlapLoggers.BUILDER_TABLE.isDebugEnabled()) {
                OlapLoggers.BUILDER_TABLE.debug((Object)("DB table [" + this.getName() + "] discover columns from columnsSql : " + tableName));
            }
        } else {
            List<IOlapBuilderTablePartitionKey> keys = this.getAvailablePartitionKeys(openedConnection);
            if (!keys.isEmpty()) {
                tableName = keys.get(0).getStrValue();
                if (OlapLoggers.BUILDER_TABLE.isDebugEnabled()) {
                    OlapLoggers.BUILDER_TABLE.debug((Object)("DB table [" + this.getName() + "] discover columns from 1st. partitionSql : " + tableName));
                }
            } else {
                tableName = null;
                if (OlapLoggers.BUILDER_TABLE.isDebugEnabled()) {
                    OlapLoggers.BUILDER_TABLE.debug((Object)("DB table [" + this.getName() + "] discover columns from partitionSql : none found"));
                }
            }
        }
        List<Object> columns = tableName != null ? OlapBuilderJdbcDataTable.doDiscoverAllColumns(tableName, openedConnection, errorManager) : new ArrayList();
        return columns;
    }

    @Override
    protected List<IOlapBuilderTablePartitionKey> doGetPartitionKeys(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, @Nullable OlapBuilderTableRequestedPartitionKeys requestedPartitions) {
        if (requestedPartitions == null) {
            return this.getAvailablePartitionKeys(context, connectionPool);
        }
        return this.getRequestedPartitionKeys(requestedPartitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IOlapBuilderTablePartitionKey> getAvailablePartitionKeys(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool) {
        OlapBuilderJdbcConnection connection = (OlapBuilderJdbcConnection)connectionPool.getOrCreateOpenedConnection(context.asRuntimeContext(), this.getDataSource());
        try {
            List<IOlapBuilderTablePartitionKey> list = this.getAvailablePartitionKeys(connection);
            return list;
        }
        finally {
            connectionPool.releaseOpenedConnection(connection);
        }
    }

    private List<IOlapBuilderTablePartitionKey> getAvailablePartitionKeys(OlapBuilderJdbcConnection connection) {
        ArrayList<IOlapBuilderTablePartitionKey> arrayList;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            if (OlapLoggers.BUILDER_TABLE.isDebugEnabled()) {
                OlapLoggers.BUILDER_TABLE.debug((Object)("DB table - partition names : " + this.partitionsSql));
            }
            statement = connection.createStatement(this.partitionsSql, this.fetchSize);
            resultSet = statement.executeQuery();
            ArrayList<IOlapBuilderTablePartitionKey> keys = new ArrayList<IOlapBuilderTablePartitionKey>();
            while (resultSet.next()) {
                Object partitionKey;
                String partitionKeyS;
                if (resultSet.wasNull() || (partitionKeyS = (partitionKey = resultSet.getObject(1)) != null ? partitionKey.toString() : null) == null) continue;
                if (OlapLoggers.BUILDER_TABLE.isDebugEnabled()) {
                    OlapLoggers.BUILDER_TABLE.debug((Object)("DB table - partition name  : " + partitionKeyS));
                }
                keys.add(new OlapBuilderJdbcUnionTablePartitionKey(partitionKeyS));
            }
            if (OlapLoggers.BUILDER_TABLE.isDebugEnabled()) {
                OlapLoggers.BUILDER_TABLE.debug((Object)("DB table - partition names : " + keys.size()));
            }
            arrayList = keys;
        }
        catch (SQLException ex) {
            try {
                OlapLoggers.BUILDER_TABLE.error((Object)("DB table [" + this.getName() + "] partition names lookup error"), (Throwable)ex);
                throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.DATA_PROCESSING_FAILED, new Serializable[]{this.getName(), ex.getLocalizedMessage()});
            }
            catch (Throwable throwable) {
                CdJdbcUtils.closeQuietly(resultSet);
                CdJdbcUtils.closeQuietly(statement);
                throw throwable;
            }
        }
        CdJdbcUtils.closeQuietly((ResultSet)resultSet);
        CdJdbcUtils.closeQuietly((Statement)statement);
        return arrayList;
    }

    private List<IOlapBuilderTablePartitionKey> getRequestedPartitionKeys(OlapBuilderTableRequestedPartitionKeys requestedPartitions) {
        if (requestedPartitions.isRange()) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.RANGE_PARTITION_NOT_SUPPORTED, new Serializable[]{this.getName()});
        }
        ArrayList<IOlapBuilderTablePartitionKey> tKeys = new ArrayList<IOlapBuilderTablePartitionKey>();
        List<String> rKeys = requestedPartitions.getKeys();
        for (String rKey : rKeys) {
            tKeys.add(new OlapBuilderJdbcUnionTablePartitionKey(rKey));
        }
        return tKeys;
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderJdbcConnection> doCreatePartitionTableRowReaders(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, IOlapBuilderTablePartitionKey partitionKey) {
        OlapBuilderJdbcConnection connection = (OlapBuilderJdbcConnection)connectionPool.getOrCreateOpenedConnection(context.asRuntimeContext(), this.getDataSource());
        try {
            String sql = this.createPartitionSql(connection, partitionKey);
            OlapBuilderJdbcUnionDataTablePartitionRowReader olapBuilderJdbcUnionDataTablePartitionRowReader = new OlapBuilderJdbcUnionDataTablePartitionRowReader(context, connectionPool, this, partitionKey, sql);
            return olapBuilderJdbcUnionDataTablePartitionRowReader;
        }
        catch (SQLException ex) {
            OlapLoggers.BUILDER_TABLE.error((Object)("DB table [" + this.getName() + "] row-reader setup error"), (Throwable)ex);
            throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.DATA_PROCESSING_FAILED, new Serializable[]{this.getName(), ex.getLocalizedMessage()});
        }
        finally {
            connectionPool.releaseOpenedConnection(connection);
        }
    }

    private String createPartitionSql(OlapBuilderJdbcConnection connection, IOlapBuilderTablePartitionKey partitionKey) throws SQLException {
        String sql = CdStringUtils.isNotNullAndNotBlank((String)this.partitionSql) ? this.partitionSql : DEFAULT_PARTITION;
        sql = sql.replace("$PARTITION$", connection.getTableNameForSqlStatement(partitionKey.getStrValue()));
        sql = sql.replace("$COLUMNS$", this.getColumnsSql(connection));
        if (OlapLoggers.BUILDER_TABLE.isDebugEnabled()) {
            OlapLoggers.BUILDER_TABLE.debug((Object)("DB table [" + this.getName() + "] partitionSql setup : " + sql));
        }
        return sql;
    }

    private String getColumnsSql(OlapBuilderJdbcConnection connection) throws SQLException {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IOlapBuilderDataColumnDef columnDef : this.getSelectedColumns()) {
            if (!columnDef.isForTableSelect()) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(OlapBuilderJdbcDataTable.getJbcColumnName(connection, columnDef));
            first = false;
        }
        return sb.toString();
    }

    @Override
    protected String createSelectStatement(OlapBuilderJdbcConnection connection, boolean incrLoad) throws SQLException {
        if (incrLoad) {
            OlapLoggers.BUILDER_TABLE.error((Object)("DB table [" + this.getName() + "] full row-reader setup error (incr. load)"));
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATA_PROCESSING_FAILED, new Serializable[]{this.getName(), "incr. load w/ union partitioning not supported yet"});
        }
        List<IOlapBuilderTablePartitionKey> keys = this.getAvailablePartitionKeys(connection);
        if (keys.isEmpty()) {
            return "";
        }
        StringBuilder unionAll = new StringBuilder();
        for (int kk = 0; kk < keys.size(); ++kk) {
            IOlapBuilderTablePartitionKey key = keys.get(kk);
            if (kk > 0) {
                unionAll.append(" UNION ALL ");
            }
            unionAll.append(this.createPartitionSql(connection, key));
        }
        String sql = unionAll.toString();
        return sql;
    }

    @Override
    public OlapBuilderValidator<IOlapBuilderDataSource<OlapBuilderJdbcConnection>, IOlapBuilderDataTableDef<OlapBuilderJdbcConnection>> getValidator() {
        return new OlapBuilderJdbcUnionDataTableValidator();
    }
}

