/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderBaseJdbcDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcTypedDatasource;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderJdbcStatementValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@XmlRootElement(name="jdbcStatement")
public class OlapBuilderJdbcStatementDataTable
extends OlapBuilderBaseJdbcDataTable {
    public static final CdProperty SQL_STATEMENT = new CdReadWriteProperty(OlapBuilderJdbcStatementDataTable.class, "sql");
    public static final CdProperty SQL_INCREMENTAL_STATEMENT = new CdReadWriteProperty(OlapBuilderJdbcStatementDataTable.class, "sqlIncremental");
    @XmlElement(name="sqlStatement", required=true)
    private String sqlStatement;
    @XmlElement(name="sqlIncremental", required=true)
    private String sqlIncremental;

    public OlapBuilderJdbcStatementDataTable() {
    }

    public OlapBuilderJdbcStatementDataTable(int defaultFetchSize) {
        super(defaultFetchSize);
    }

    public OlapBuilderJdbcStatementDataTable(String tableName, String sqlStatement, int defaultFetchSize) {
        super(tableName, defaultFetchSize);
        this.sqlStatement = sqlStatement;
    }

    public OlapBuilderJdbcStatementDataTable(String tableName, String sqlStatement) {
        this(tableName, sqlStatement, 1000);
    }

    @Override
    public boolean isNameReadOnly() {
        return false;
    }

    @Override
    public String getInternalFriendlyTypeName() {
        return "JDBC Statement";
    }

    public String getSql() {
        return this.sqlStatement;
    }

    public void setSql(String sql) {
        this.sqlStatement = sql;
    }

    public String getSqlIncremental() {
        return this.sqlIncremental;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderJdbcConnection openedConnection, OlapBuilderErrorManager errorManager) throws Exception {
        if (OlapLoggers.BUILDER.isDebugEnabled()) {
            OlapLoggers.BUILDER.debug((Object)("[DB] discovering columns for table [" + this.getName() + "] started"));
        }
        try {
            ArrayList columns = new ArrayList();
            OlapBuilderJdbcTypedDatasource typedDataSource = ((OlapBuilderJdbcDataSource)this.getDataSource()).getOrCreateTypedDataSource();
            typedDataSource.onResultSetMetaData(openedConnection, this.getSql(), meta -> OlapBuilderJdbcDataSource.addColumnsFromQueryMeta(columns, meta, "sql-statement"));
            ArrayList arrayList = columns;
            return arrayList;
        }
        finally {
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)("[DB] discovering columns for table [" + this.getName() + "] done"));
            }
        }
    }

    @Override
    protected String createSelectStatement(OlapBuilderJdbcConnection connection, boolean incrLoad) throws SQLException {
        Object ret = incrLoad ? (CdStringUtils.isNotNullAndNotBlank((String)this.sqlIncremental) ? this.sqlIncremental : "SELECT * FROM (" + this.getSql() + ") temp " + this.getIncrementalWhereClause(connection)) : this.getSql();
        return ret;
    }

    @Override
    public OlapBuilderValidator<IOlapBuilderDataSource<OlapBuilderJdbcConnection>, IOlapBuilderDataTableDef<OlapBuilderJdbcConnection>> getValidator() {
        return new OlapBuilderJdbcStatementValidator();
    }

    @Override
    public boolean isDiscoveredInDataSource() {
        return false;
    }

    @Override
    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable) {
        if (super.isRefreshColumnOnUpdate(newTable)) {
            return true;
        }
        OlapBuilderJdbcStatementDataTable tableUpdate = (OlapBuilderJdbcStatementDataTable)newTable;
        return !Objects.equals(this.sqlStatement, tableUpdate.sqlStatement);
    }
}

