/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc;

import crazydev.common.utils.CdJdbcUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderBaseJdbcDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.OlapBuilderAbstractTableRow;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Objects;

public abstract class OlapBuilderJdbcDataTableRowReader
extends OlapBuilderAbstractTableRowReader<OlapBuilderBaseJdbcDataTable, OlapBuilderJdbcConnection> {
    protected boolean emptyRS = false;
    protected PreparedStatement statement;
    protected ResultSet resultSet;

    public OlapBuilderJdbcDataTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderBaseJdbcDataTable table) {
        super(context, connectionPool, maxRowCount, table, table.getName());
    }

    @Override
    public void doInit() {
        if (OlapLoggers.JDBC.isDebugEnabled()) {
            OlapLoggers.JDBC.debug((Object)("[JDBC] table [" + this.getTableName() + "] reader init : get-or-creating a new connection"));
        }
        this.initConnection();
        if (OlapLoggers.JDBC.isDebugEnabled() && this.connection != null) {
            OlapLoggers.JDBC.debug((Object)("[JDBC] table [" + this.getTableName() + "] reader using the connection [" + System.identityHashCode(this.connection) + "]"));
        }
        OlapBuilderJdbcDataSource ds = ((OlapBuilderBaseJdbcDataTable)this.table).getTypedDataSource();
        this.extractStringToDateConverter(ds.getStringConverterLocale(), ds.getStringDateConverter());
    }

    @Override
    public boolean isRowSafe() {
        return false;
    }

    @Override
    public IOlapBuilderTableRow doNextRow() {
        try {
            if (this.emptyRS || !this.resultSet.next()) {
                return null;
            }
        }
        catch (SQLException ex) {
            OlapLoggers.BUILDER_TABLE.error((Object)("DB table [" + this.getTableName() + "] processing error"), (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATA_PROCESSING_FAILED, new Serializable[]{this.getTableName(), ex.getMessage()});
        }
        boolean isAccessJdk = ((OlapBuilderJdbcDataSource)((OlapBuilderJdbcConnection)this.connection).getDataSource()).isAccessJdk();
        if (!isAccessJdk) {
            return this.createTableRow();
        }
        return this.createTableRowForAccessJdk();
    }

    @Override
    public void done() {
        if (OlapLoggers.JDBC.isDebugEnabled()) {
            OlapLoggers.JDBC.debug((Object)("[JDBC] table [" + this.getTableName() + "] reader done - cancel the statement [" + String.valueOf(this.connection == null ? "" : Integer.valueOf(System.identityHashCode(this.connection))) + "]"));
        }
        CdJdbcUtils.cancelQuietly((Statement)this.statement);
        if (OlapLoggers.JDBC.isDebugEnabled()) {
            OlapLoggers.JDBC.debug((Object)("[JDBC] table [" + this.getTableName() + "] reader done - releasing the result-set [" + String.valueOf(this.connection == null ? "" : Integer.valueOf(System.identityHashCode(this.connection))) + "]"));
        }
        CdJdbcUtils.closeQuietly((ResultSet)this.resultSet);
        if (OlapLoggers.JDBC.isDebugEnabled()) {
            OlapLoggers.JDBC.debug((Object)("[JDBC] table [" + this.getTableName() + "] reader done - releasing the statement [" + String.valueOf(this.connection == null ? "" : Integer.valueOf(System.identityHashCode(this.connection))) + "]"));
        }
        CdJdbcUtils.closeQuietly((Statement)this.statement);
        if (OlapLoggers.JDBC.isDebugEnabled()) {
            OlapLoggers.JDBC.debug((Object)("[JDBC] table [" + this.getTableName() + "] reader done - releasing the connection [" + String.valueOf(this.connection == null ? "" : Integer.valueOf(System.identityHashCode(this.connection))) + "]"));
        }
        super.done();
    }

    private IOlapBuilderTableRow createTableRow() {
        return new OlapBuilderAbstractTableRow(this){
            final /* synthetic */ OlapBuilderJdbcDataTableRowReader this$0;
            {
                OlapBuilderJdbcDataTableRowReader olapBuilderJdbcDataTableRowReader = this$0;
                Objects.requireNonNull(olapBuilderJdbcDataTableRowReader);
                this.this$0 = olapBuilderJdbcDataTableRowReader;
            }

            @Override
            public Object getDataImpl(IOlapBuilderDataColumnDef columnDef) {
                String name = columnDef.getName();
                try {
                    Object value = this.this$0.getValue(columnDef, name);
                    return value;
                }
                catch (SQLException ex) {
                    OlapLoggers.BUILDER_TABLE.error((Object)("DB table [" + this.this$0.getTableName() + "] [col:" + name + "] processing error"), (Throwable)ex);
                    throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.DATA_PROCESSING_FAILED, new Serializable[]{this.this$0.getTableName(), "[col:" + name + "] " + ex.getMessage()});
                }
            }
        };
    }

    private IOlapBuilderTableRow createTableRowForAccessJdk() {
        final HashMap cache = new HashMap();
        return new OlapBuilderAbstractTableRow(this){
            final /* synthetic */ OlapBuilderJdbcDataTableRowReader this$0;
            {
                OlapBuilderJdbcDataTableRowReader olapBuilderJdbcDataTableRowReader = this$0;
                Objects.requireNonNull(olapBuilderJdbcDataTableRowReader);
                this.this$0 = olapBuilderJdbcDataTableRowReader;
            }

            @Override
            public Object getDataImpl(IOlapBuilderDataColumnDef columnDef) {
                String name = columnDef.getName();
                try {
                    Object value = cache.get(name);
                    if (value == null) {
                        value = this.this$0.getValue(columnDef, name);
                        cache.put(name, value == null ? this : value);
                    }
                    if (value == this) {
                        return null;
                    }
                    return value;
                }
                catch (SQLException ex) {
                    OlapLoggers.BUILDER_TABLE.error((Object)("DB table [" + this.this$0.getTableName() + "] [col:" + name + "] processing error"), (Throwable)ex);
                    throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.DATA_PROCESSING_FAILED, new Serializable[]{this.this$0.getTableName(), "[col:" + name + "] " + ex.getMessage()});
                }
            }
        };
    }

    private Object getValue(IOlapBuilderDataColumnDef columnDef, String name) throws SQLException {
        int index = columnDef.getJdbcIndex();
        if (index == -1) {
            index = this.resultSet.findColumn(name);
            columnDef.setJdbcIndex(index);
        }
        Object value = this.resultSet.getObject(index);
        if (columnDef.getType().isDateType() && value instanceof String && this.hasStringToDate()) {
            value = this.parseStringToDate(columnDef, (String)value);
        }
        if (columnDef.isArray() && value instanceof Array) {
            value = ((Array)value).getArray();
        }
        return value;
    }
}

