/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderBaseJdbcDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import org.apache.log4j.Logger;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapBuilderJdbcDataTableFullRowReader
extends OlapBuilderJdbcDataTableRowReader {
    public OlapBuilderJdbcDataTableFullRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderBaseJdbcDataTable table) {
        super(context, connectionPool, maxRowCount, table);
    }

    @Override
    public void doInit() {
        super.doInit();
        String sql = "";
        try {
            Comparable incrLoadMarker = this.context.getIncrementalLoadMarker(this.table);
            sql = ((OlapBuilderBaseJdbcDataTable)this.table).createSelectStatement((OlapBuilderJdbcConnection)this.connection, incrLoadMarker != null);
            if (OlapLoggers.BUILDER_TABLE.isDebugEnabled()) {
                OlapLoggers.BUILDER_TABLE.debug((Object)("DB table SQL (fetchSize=" + ((OlapBuilderBaseJdbcDataTable)this.table).fetchSize + "):" + sql));
            }
            if (CdStringUtils.isNullOrBlank((String)sql)) {
                this.emptyRS = true;
                return;
            }
            this.statement = ((OlapBuilderJdbcConnection)this.connection).createStatement(sql, ((OlapBuilderBaseJdbcDataTable)this.table).fetchSize);
            if (this.maxRowCount != -1) {
                this.statement.setMaxRows(this.maxRowCount);
            }
            if (incrLoadMarker != null) {
                if (incrLoadMarker instanceof LocalDate) {
                    LocalDate localDate = (LocalDate)incrLoadMarker;
                    date = localDate.toDate();
                    long time = date.getTime();
                    this.statement.setDate(1, new Date(time));
                } else if (incrLoadMarker instanceof LocalDateTime) {
                    LocalDateTime localDateTime = (LocalDateTime)incrLoadMarker;
                    date = localDateTime.toDate();
                    long time = date.getTime();
                    this.statement.setTime(1, new Time(time));
                } else {
                    this.statement.setObject(1, incrLoadMarker);
                }
            }
            Logger logger = this.context.getLoggers().builderTable();
            long startMS = System.currentTimeMillis();
            this.resultSet = this.statement.executeQuery();
            long elapsedMS = System.currentTimeMillis() - startMS;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("table [%s] [ partition : %s ] has executed the query [ %s sec ]", ((OlapBuilderBaseJdbcDataTable)this.table).getName(), this.getName(), CdStringUtils.formatNice((long)((int)((double)elapsedMS / 1000.0)))));
            }
        }
        catch (SQLException ex) {
            OlapLoggers.BUILDER_TABLE.error((Object)("DB table [" + this.getTableName() + "] processing error"), (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.DATA_PROCESSING_FAILED, new Serializable[]{this.getFullTableNameForEndUser(), ex.getLocalizedMessage() + ". [" + sql + "]"});
        }
    }

    @Override
    public boolean isRowSafe() {
        return false;
    }
}

