/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.security.CdPassword;
import crazydev.common.utils.CdJdbcUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdLocaleXmlAdapter;
import crazydev.common.xml.CdPasswordXmlAdapter;
import crazydev.common.xml.CdXmlParametersUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderBaseJdbcDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderDriverType;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSourceException;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcSimilarTo;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcStatementDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcUnionDataTable;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderHiveSqlTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcAWSAthenaTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcAWSRedshiftTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcAccessJdkTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcDb2TypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcHyperSqlTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcKylinTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcMySQLTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcOracleTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcPlainTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcPostgresTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcSimbaBigQueryTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcSnowflakeTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcSqlAnywhereTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcSqlServerTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcSybaseTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcTrinoTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.typed.OlapBuilderJdbcTypedDatasource;
import crazydev.iccube.builder.datasource.jdbc.ux.UxBuilderDB2JdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.ux.UxBuilderMySqlJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.ux.UxBuilderOracleJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.ux.UxBuilderPostgresJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.ux.UxBuilderRedshiftJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.ux.UxBuilderSqlServerJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.ux.UxBuilderSybaseJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.ux.UxBuilderTrinoJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.ux.UxBuilderUrlJdbcDataSource;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.IOlapBuilderValidationEnabled;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.model.validation.OlapBuilderJdbcDataSourceValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceTypeGroupId;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateTypedDataSourceWizard;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderDataSourceNameForm;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="jdbcDS")
public class OlapBuilderJdbcDataSource
extends OlapBuilderBaseDataSource<OlapBuilderJdbcConnection>
implements IOlapBuilderJaxbListener {
    public static final Logger LOGGER = OlapLoggers.BUILDER;
    public static final CdProperty DB_TYPE = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "dbType", CdProperty.Access.METHOD);
    public static final CdProperty DRIVER_TYPE = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "driverType");
    public static final CdProperty SIMILAR_TO = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "similarTo");
    public static final CdProperty SERVER_NAME = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "serverName");
    public static final CdProperty PORT_NUMBER = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "portNumber");
    public static final CdProperty DB_NAME = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "dbName");
    public static final CdProperty SCHEMA_NAME = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "schemaName", false);
    public static final CdProperty CATALOG_NAME = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "catalog", false);
    public static final CdProperty URL_PARAMS = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "urlParams");
    public static final CdProperty USER = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "user");
    public static final CdProperty PASSWORD = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "password");
    public static final CdProperty PLAYGROUND = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "playground");
    public static final CdProperty STRING_CONVERTER_LOCALE = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "stringConverterLocale");
    public static final CdProperty DATE_FORMAT = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "stringDateConverter");
    public static final CdProperty DATE_FORMAT_NG = new CdReadWriteProperty(OlapBuilderJdbcDataSource.class, "stringDateConverter"){

        public String getNameForDescription() {
            return super.getName() + "NG";
        }
    };
    static final List<Class<? extends IOlapBuilderTabularDataDef>> CREATED_TABLE_TYPES = Arrays.asList(OlapBuilderJdbcStatementDataTable.class, OlapBuilderJdbcUnionDataTable.class);
    @XmlAttribute(required=true)
    private OlapBuilderDriverType driverType;
    @XmlAttribute(required=false)
    @Nullable
    private OlapBuilderJdbcSimilarTo similarTo;
    @XmlAttribute(required=true)
    private String serverName;
    @XmlAttribute(required=false)
    private String portNumber;
    @XmlAttribute(required=true)
    private String dbName;
    @XmlAttribute
    private boolean dontAddQuotes;
    @XmlAttribute(required=true)
    private String user;
    @XmlJavaTypeAdapter(value=CdPasswordXmlAdapter.class)
    @XmlAttribute(required=false)
    @Nullable
    private CdPassword password;
    @XmlAttribute(required=false)
    private String schemaName;
    @XmlAttribute(required=false)
    private String catalog;
    @XmlAttribute(required=false)
    private String urlParams;
    @XmlAttribute(required=false)
    private String playground;
    @XmlAttribute(required=false)
    private String stringDateConverter;
    @XmlJavaTypeAdapter(value=CdLocaleXmlAdapter.class)
    @XmlElement(name="stringDateConverterLocale")
    private Locale stringConverterLocale;
    @XmlTransient
    @Nullable
    private OlapBuilderJdbcTypedDatasource typedDataSource;
    @XmlTransient
    @Nullable
    private String cachedURL;
    @XmlTransient
    @Nullable
    private Properties cachedParams;

    public OlapBuilderJdbcDataSource() {
    }

    public OlapBuilderJdbcDataSource(OlapBuilderDriverType driverType) {
        this.driverType = driverType;
    }

    public OlapBuilderJdbcDataSource(OlapBuilderJdbcDataSource ds, OlapBuilderDriverType driverType) {
        super(ds.getName(), ds.getDescription(), ds.getVisibility(), ds.isIncludeSynonyms(), ds.disableReadOnlyMode(), ds.disableAutoCommitFalse());
        this.driverType = driverType;
        this.serverName = ds.serverName;
        this.portNumber = ds.portNumber;
        this.dbName = ds.dbName;
        this.user = ds.user;
        this.dontAddQuotes = ds.dontAddQuotes;
        this.password = ds.password;
        this.schemaName = ds.schemaName;
        this.catalog = ds.catalog;
        this.urlParams = ds.urlParams;
        this.stringDateConverter = ds.stringDateConverter;
        this.stringConverterLocale = ds.stringConverterLocale;
        this.playground = ds.playground;
        this.similarTo = ds.similarTo;
    }

    public OlapBuilderJdbcDataSource(String name, OlapBuilderDriverType driverType, String serverName, String dbName, String user, String password) {
        super(name);
        this.driverType = driverType;
        this.serverName = serverName;
        this.dbName = dbName;
        this.user = user;
        this.password = new CdPassword(password, null);
    }

    public OlapBuilderJdbcDataSource(String name, OlapBuilderDriverType driverType, String serverName, @Nullable Integer portNumber, String dbName, String user, String password, boolean dontAddQuotes) {
        super(name);
        this.driverType = driverType;
        this.serverName = serverName;
        this.portNumber = portNumber != null ? String.valueOf(portNumber) : null;
        this.dbName = dbName;
        this.user = user;
        this.password = new CdPassword(password, null);
        this.dontAddQuotes = dontAddQuotes;
    }

    public OlapBuilderJdbcDataSource(String driverName, String url, String user, String password) {
        super(url);
        this.driverType = OlapBuilderDriverType.SERVER_AS_JDBCDRIVER_DBNAME_AS_JDBCURL;
        this.serverName = driverName;
        this.dbName = url;
        this.user = user;
        this.password = new CdPassword(password, null);
    }

    @Override
    public UxBuilderDataSourceTypeGroupId getUxGroupId() {
        return UxBuilderDataSourceTypeGroupId.dsTypeGroupSql;
    }

    @Override
    protected String getReportDataSourceType() {
        return "jdbc";
    }

    @Override
    protected String getReportDataSourceTypeCaption() {
        return "SQL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdated() {
        super.onUpdated();
        OlapBuilderJdbcDataSource olapBuilderJdbcDataSource = this;
        synchronized (olapBuilderJdbcDataSource) {
            this.typedDataSource = null;
            this.cachedURL = null;
            this.cachedParams = null;
        }
    }

    public OlapBuilderDriverType getDriverType() {
        return this.driverType;
    }

    public void setDriverType(OlapBuilderDriverType driverType) {
        this.driverType = driverType;
    }

    public boolean isMySql() {
        if (this.driverType == null) {
            throw new CdProgrammingException("missing driverType");
        }
        String url = this.getOrCreateURL();
        return this.driverType.isMySql(url);
    }

    public boolean isDb2() {
        if (this.driverType == null) {
            throw new CdProgrammingException("missing driverType");
        }
        String url = this.getOrCreateURL();
        return this.driverType.isDb2(url);
    }

    public boolean isSybase() {
        if (this.driverType == null) {
            throw new CdProgrammingException("missing driverType");
        }
        String url = this.getOrCreateURL();
        return this.driverType.isSybase(url);
    }

    public boolean isSqlServer() {
        if (this.driverType == null) {
            throw new CdProgrammingException("missing driverType");
        }
        String url = this.getOrCreateURL();
        return this.driverType.isSqlServer(url);
    }

    private boolean isAWSRedshift() {
        if (this.driverType == null) {
            throw new CdProgrammingException("missing driverType");
        }
        String url = this.getOrCreateURL();
        return this.driverType.isAWSRedshift(url);
    }

    private boolean isOracle() {
        if (this.driverType == null) {
            throw new CdProgrammingException("missing driverType");
        }
        String url = this.getOrCreateURL();
        return this.driverType.isOracle(url);
    }

    private boolean isSnowflake() {
        if (this.driverType == null) {
            throw new CdProgrammingException("missing driverType");
        }
        String url = this.getOrCreateURL();
        return this.driverType.isSnowflake(url);
    }

    public boolean isTrino() {
        if (this.driverType == null) {
            throw new CdProgrammingException("missing driverType");
        }
        String url = this.getOrCreateURL();
        return this.driverType.isTrino(url);
    }

    public boolean isAthena() {
        if (this.driverType == null) {
            throw new CdProgrammingException("missing driverType");
        }
        String url = this.getOrCreateURL();
        return this.driverType.isAthena(url);
    }

    private boolean isSqlAnywhere() {
        if (this.driverType == null) {
            throw new CdProgrammingException("missing driverType");
        }
        String url = this.getOrCreateURL();
        return this.driverType.isSqlAnywhere(url);
    }

    private boolean isHyperSQL() {
        if (this.driverType == null) {
            throw new CdProgrammingException("missing driverType");
        }
        String url = this.getOrCreateURL();
        return this.driverType.isHyperSQL(url);
    }

    private boolean isPostgres() {
        if (this.driverType == null) {
            throw new CdProgrammingException("missing driverType");
        }
        String url = this.getOrCreateURL();
        return this.driverType.isPostgres(url);
    }

    public boolean isAccessJdk() {
        if (this.driverType == null) {
            throw new CdProgrammingException("missing driverType");
        }
        String url = this.getOrCreateURL();
        return this.driverType.isAccessJdk(url);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getCatalogEx() {
        return CdXmlParametersUtils.replace((String)this.catalog);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getSchemaNameEx() {
        return CdXmlParametersUtils.replace((String)this.schemaName);
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbNameEx() {
        return CdXmlParametersUtils.replace((String)this.dbName);
    }

    public String getDriverName() {
        return this.driverType.getDriverName(this.serverName);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUserEx() {
        return CdPasswordXmlAdapter.unmarshalVariable((String)this.user);
    }

    public String getUrlParams() {
        return this.urlParams;
    }

    public void setUrlParams(String urlParams) {
        this.urlParams = urlParams;
    }

    @Nullable
    public String getPlayground() {
        return this.playground;
    }

    @Override
    public boolean isDiscoverTablesSupported() {
        return true;
    }

    public void assertJdbcDriver() throws OlapBuilderJdbcDataSourceException {
    }

    @Override
    public OlapBuilderJdbcConnection createConnection(OlapRuntimeContext context, boolean forceRefresh) {
        return new OlapBuilderJdbcConnection(this);
    }

    @Override
    @Nullable
    public List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes() {
        return CREATED_TABLE_TYPES;
    }

    @Override
    public OlapBuilderValidator<IOlapBuilderValidationEnabled, IOlapBuilderDataSource> getValidator() {
        return new OlapBuilderJdbcDataSourceValidator();
    }

    @Override
    public OlapBuilderBaseDataTable<OlapBuilderJdbcConnection> createEmptyCreateTable(@Nullable Class<IOlapBuilderTabularDataDef> tableType) {
        if (tableType != null && OlapBuilderJdbcUnionDataTable.class.isAssignableFrom(tableType)) {
            return new OlapBuilderJdbcUnionDataTable(this.getDefaultFetchSize());
        }
        return new OlapBuilderJdbcStatementDataTable(this.getDefaultFetchSize());
    }

    public OlapBuilderBaseJdbcDataTable createEmptyDiscoverTable(String tableName) {
        return new OlapBuilderJdbcDataTable(tableName, this.getDefaultFetchSize());
    }

    public int getDefaultFetchSize() {
        OlapBuilderJdbcTypedDatasource typedDataSource = this.getOrCreateTypedDataSource();
        return typedDataSource.getDefaultFetchSize();
    }

    @Override
    public List<String> discoverAllTablesNames(OlapBuilderJdbcConnection openedConnection, boolean filterSystemSchemas, @Nullable String filter) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"[DB] discovering all tables started");
        }
        int maxLogCount = 512;
        int logCount = 0;
        ArrayList<String> dataTables = new ArrayList<String>();
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = openedConnection.getMetaData();
            rs = this.getDbTables(metaData, null);
            while (rs.next()) {
                String tableCatalog = rs.getString("TABLE_CAT");
                String tableSchema = rs.getString("TABLE_SCHEM");
                String tableType = rs.getString("TABLE_TYPE");
                String tableName = rs.getString("TABLE_NAME");
                if (logCount < 512) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("[DB] discovering table : " + tableName + " . " + tableType + " . schema:" + tableSchema + " . catalog:" + tableCatalog));
                    }
                    ++logCount;
                }
                OlapBuilderJdbcTypedDatasource dataSource = this.getOrCreateTypedDataSource();
                if (!filterSystemSchemas || dataSource.isSchemaAccepted(tableSchema)) {
                    String dbTableName = dataSource.getTableNameForCreateTable(metaData, tableCatalog, tableSchema, tableName);
                    if (!this.acceptTableNameForDiscoverTableNames(filter, dbTableName)) continue;
                    dataTables.add(dbTableName);
                    continue;
                }
                if (logCount >= 512) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("[DB] excluded table : " + tableName + " . " + tableType + " . schema:" + tableSchema + " . catalog:" + tableCatalog));
                }
                ++logCount;
            }
        }
        catch (SQLException e) {
            try {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.FAILED_TO_LOAD_TABLES_FROM_DATASOURCE, new Serializable[]{this.getName(), e.getLocalizedMessage()});
            }
            catch (Throwable throwable) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"[DB] discovering all tables done");
                }
                CdJdbcUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"[DB] discovering all tables done");
        }
        CdJdbcUtils.closeQuietly((ResultSet)rs);
        return dataTables;
    }

    public ResultSet getDbTables(DatabaseMetaData metaData, @Nullable String tableNamePattern) throws SQLException {
        OlapBuilderJdbcTypedDatasource typedDataSource = this.getOrCreateTypedDataSource();
        return typedDataSource.getDbTables(metaData, tableNamePattern);
    }

    public ResultSet getDbColumns(DatabaseMetaData metaData, String tableName) throws SQLException {
        OlapBuilderJdbcTypedDatasource typedDataSource = this.getOrCreateTypedDataSource();
        return typedDataSource.getDbColumns(metaData, tableName);
    }

    public synchronized String getOrCreateURL() {
        if (this.cachedURL != null) {
            return this.cachedURL;
        }
        String urlEx = CdXmlParametersUtils.replace((String)this.driverType.getDefinedUrl());
        String serverNameEx = CdXmlParametersUtils.replace((String)this.serverName);
        String portNumberEx = CdXmlParametersUtils.replace((String)this.portNumber);
        String catalogEx = this.getCatalogEx();
        String schemaNameEx = this.getSchemaNameEx();
        String dbNameEx = this.getDbNameEx();
        this.cachedURL = this.driverType.createURL(urlEx, serverNameEx, portNumberEx, catalogEx, schemaNameEx, dbNameEx);
        return this.cachedURL;
    }

    public synchronized Properties getOrCreateParams() throws OlapBuilderErrorException {
        if (this.cachedParams != null) {
            return this.cachedParams;
        }
        this.cachedParams = this.createParams();
        return this.cachedParams;
    }

    protected Properties createParams() throws OlapBuilderErrorException {
        String urlParamsEx = CdXmlParametersUtils.replace((String)this.urlParams);
        Properties params = new Properties();
        if (CdStringUtils.isNotNullAndNotBlank((String)urlParamsEx)) {
            try {
                params.load(new StringReader(urlParamsEx));
            }
            catch (IOException ex) {
                throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.JDBC_INVALID_PARAMS, new Serializable[]{this.getName(), ex.getMessage()});
            }
        }
        this.overrideParams(params);
        return params;
    }

    protected void overrideParams(Properties params) {
        String passwordEx;
        String userEx = CdXmlParametersUtils.replace((String)this.user);
        if (CdStringUtils.isNotNullAndNotBlank((String)userEx)) {
            params.put("user", userEx);
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)(passwordEx = CdXmlParametersUtils.replace(this.password != null ? this.password.clear : null)))) {
            params.put("password", passwordEx);
        }
        this.getOrCreateTypedDataSource().overrideParams(params);
    }

    public synchronized OlapBuilderJdbcTypedDatasource getOrCreateTypedDataSource() {
        String dbName = this.getDbNameEx();
        String schemaName = this.getSchemaNameEx();
        String catalog = this.getCatalogEx();
        if (this.typedDataSource == null) {
            String databaseName = this.getActualDbName(dbName);
            this.typedDataSource = this.similarTo != null ? OlapBuilderJdbcDataSource.createTypedDataSource(this.driverType, this.similarTo, databaseName, this.user, schemaName) : (this.isAccessJdk() ? new OlapBuilderJdbcAccessJdkTypedDatasource(this.driverType, databaseName, schemaName) : (this.isAWSRedshift() ? new OlapBuilderJdbcAWSRedshiftTypedDatasource(this.driverType, databaseName, schemaName) : (this.isDb2() ? new OlapBuilderJdbcDb2TypedDatasource(this.driverType, databaseName, schemaName) : (this.isHyperSQL() ? new OlapBuilderJdbcHyperSqlTypedDatasource(this.driverType, databaseName, schemaName) : (this.isMySql() ? new OlapBuilderJdbcMySQLTypedDatasource(this.driverType, databaseName, schemaName) : (this.isOracle() ? new OlapBuilderJdbcOracleTypedDatasource(this.driverType, databaseName, this.user, schemaName) : (this.isPostgres() ? new OlapBuilderJdbcPostgresTypedDatasource(this.driverType, databaseName, schemaName) : (this.isSnowflake() ? new OlapBuilderJdbcSnowflakeTypedDatasource(this.driverType, databaseName, schemaName) : (this.isSqlAnywhere() ? new OlapBuilderJdbcSqlAnywhereTypedDatasource(this.driverType, databaseName, schemaName) : (this.isSqlServer() ? new OlapBuilderJdbcSqlServerTypedDatasource(this.driverType, databaseName, schemaName) : (this.isSybase() ? new OlapBuilderJdbcSybaseTypedDatasource(this.driverType, databaseName, schemaName) : (this.isTrino() ? new OlapBuilderJdbcTrinoTypedDatasource(this.driverType, catalog, schemaName) : (this.isAthena() ? new OlapBuilderJdbcAWSAthenaTypedDatasource(this.driverType, catalog, schemaName) : (dbName.startsWith("jdbc:impala") || dbName.startsWith("jdbc:hive") ? new OlapBuilderHiveSqlTypedDatasource(this.driverType, databaseName, schemaName) : (dbName.startsWith("jdbc:kylin") ? new OlapBuilderJdbcKylinTypedDatasource(this.driverType, databaseName, schemaName) : new OlapBuilderJdbcMySQLTypedDatasource(this.driverType, databaseName, schemaName))))))))))))))));
        }
        return this.typedDataSource;
    }

    private static OlapBuilderJdbcTypedDatasource createTypedDataSource(OlapBuilderDriverType driverType, OlapBuilderJdbcSimilarTo similarTo, String dbName, String user, String schemaName) {
        switch (similarTo) {
            case ACCESS_JDK: {
                return new OlapBuilderJdbcAccessJdkTypedDatasource(driverType, dbName, schemaName);
            }
            case AWS_REDSHIFT: {
                return new OlapBuilderJdbcAWSRedshiftTypedDatasource(driverType, dbName, schemaName);
            }
            case HIVE: {
                return new OlapBuilderHiveSqlTypedDatasource(driverType, dbName, schemaName);
            }
            case HYPER_SQL: {
                return new OlapBuilderJdbcHyperSqlTypedDatasource(driverType, dbName, schemaName);
            }
            case MYSQL: {
                return new OlapBuilderJdbcMySQLTypedDatasource(driverType, dbName, schemaName);
            }
            case ORACLE: {
                return new OlapBuilderJdbcOracleTypedDatasource(driverType, dbName, user, schemaName);
            }
            case POSTGRES: {
                return new OlapBuilderJdbcPostgresTypedDatasource(driverType, dbName, schemaName);
            }
            case SQL_SERVER: {
                return new OlapBuilderJdbcSqlServerTypedDatasource(driverType, dbName, schemaName);
            }
            case SYBASE: {
                return new OlapBuilderJdbcSybaseTypedDatasource(driverType, dbName, schemaName);
            }
            case DB2: {
                return new OlapBuilderJdbcDb2TypedDatasource(driverType, dbName, schemaName);
            }
            case KYLIN: {
                return new OlapBuilderJdbcKylinTypedDatasource(driverType, dbName, schemaName);
            }
            case SAP_SQL_ANYWHERE: {
                return new OlapBuilderJdbcSqlAnywhereTypedDatasource(driverType, dbName, schemaName);
            }
            case SNOWFLAKE: {
                return new OlapBuilderJdbcSnowflakeTypedDatasource(driverType, dbName, schemaName);
            }
            case SIMBA_BIGQUERY: {
                return new OlapBuilderJdbcSimbaBigQueryTypedDatasource(driverType, dbName, schemaName);
            }
            case PLAIN_SQL: {
                return new OlapBuilderJdbcPlainTypedDatasource(driverType, dbName, schemaName);
            }
            case TRINO: {
                return new OlapBuilderJdbcTrinoTypedDatasource(driverType, dbName, schemaName);
            }
            case ATHENA: {
                return new OlapBuilderJdbcAWSAthenaTypedDatasource(driverType, dbName, schemaName);
            }
        }
        throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"unexpected similarTo value : " + similarTo.name()});
    }

    public void setSimilarTo(OlapBuilderJdbcSimilarTo similarTo) {
        this.similarTo = similarTo;
    }

    private String getActualDbName(String dbName) {
        if (this.driverType == OlapBuilderDriverType.SERVER_AS_JDBCDRIVER_DBNAME_AS_JDBCURL) {
            return this.getCatalogEx();
        }
        return dbName;
    }

    public String getEntityNameForSqlStatement(DatabaseMetaData meta, String name, boolean isTable) throws SQLException {
        if (!this.dontAddQuotes) {
            this.getOrCreateTypedDataSource();
            return this.typedDataSource.getEntityNameForSqlStatement(meta, name, isTable);
        }
        return name;
    }

    public void afterDiscoverColumns(OlapBuilderJdbcConnection openedConnection) {
        if (this.typedDataSource != null) {
            this.typedDataSource.afterDiscoverColumns(openedConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOlapBuilderDataTableDef<OlapBuilderJdbcConnection> createTableForExecuteSql(OlapEngineRequestContext requestContext, OlapBuilderConnectionPool connectionPool, OlapBuilderErrorManager errorManager, String statement) {
        if (OlapLoggers.GVI_REQUEST.isInfoEnabled()) {
            OlapRequestId requestId = requestContext.getRequestId();
            OlapLoggers.GVI_REQUEST.info((Object)("JDBC Data Source SQL Query (req:" + requestId.getId() + ") SQL statement (uuid:" + requestId.getClientUUID() + ") \n" + statement));
        }
        OlapBuilderJdbcStatementDataTable table = new OlapBuilderJdbcStatementDataTable("JDBC Statement Table", statement, this.getDefaultFetchSize());
        table.setDataSource(this);
        OlapBuilderJdbcConnection connection = connectionPool.getOrCreateOpenedConnection(requestContext.asRuntimeContext(), this);
        try {
            List<IOlapBuilderDataColumnDef> columns = table.discoverAllColumns(requestContext.asRuntimeContext(), connection, errorManager);
            table.addColumns(columns);
        }
        finally {
            connectionPool.releaseOpenedConnection(connection);
        }
        return table;
    }

    public OlapBuilderDriverType getDbType() {
        return this.driverType;
    }

    public void setDbType(OlapBuilderDriverType dbType) {
        this.driverType = dbType;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    @Override
    public String getHelpUrl() {
        return "ds_database";
    }

    @Override
    protected UxBuilderDataSourceType createUxType() {
        String id = this.getTypeId();
        return new UxBuilderDataSourceType(id, this.getUxTypeImage(), () -> new UxBuilderCreateTypedDataSourceWizard(this, id, this.createUxCreateWizardSteps()){
            {
                Objects.requireNonNull(this$0);
                super(dataSourceTypeId, steps);
            }

            @Override
            public UxBuilderWizardValidation validate(OlapRuntimeContext context, int activeStep) {
                UxBuilderDataSourceNameForm name = (UxBuilderDataSourceNameForm)((UxBuilderWizardStep)this.steps.get(0)).getModel();
                OlapBuilderJdbcDataSource props = (OlapBuilderJdbcDataSource)((UxBuilderWizardStep)this.steps.get(1)).getModel();
                props.setNameAndDescription(name.getName(), name.getDescription());
                String driverName = props.getDriverName();
                try {
                    Class.forName(driverName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    return new UxBuilderWizardValidation(activeStep);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    OlapLoggers.UX_REQUEST_BUILDER.error((Object)"[ux.builder] datasource validation error", (Throwable)ex);
                    throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.JDBC_DRIVER_CANNOT_BE_INSTANTIATED, new Serializable[]{driverName});
                }
                catch (ClassNotFoundException ex) {
                    OlapLoggers.UX_REQUEST_BUILDER.error((Object)"[ux.builder] datasource validation error", (Throwable)ex);
                    throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.JDBC_DRIVER_NOT_FOUND, new Serializable[]{driverName});
                }
            }
        });
    }

    @Override
    protected List<UxBuilderDataSourceType> createUxTypes() {
        ArrayList<UxBuilderDataSourceType> types = new ArrayList<UxBuilderDataSourceType>();
        types.add(new UxBuilderDB2JdbcDataSource().createUxType());
        types.add(new UxBuilderMySqlJdbcDataSource().createUxType());
        types.add(new UxBuilderOracleJdbcDataSource().createUxType());
        types.add(new UxBuilderPostgresJdbcDataSource().createUxType());
        types.add(new UxBuilderRedshiftJdbcDataSource().createUxType());
        types.add(new UxBuilderSqlServerJdbcDataSource().createUxType());
        types.add(new UxBuilderSybaseJdbcDataSource().createUxType());
        types.add(new UxBuilderTrinoJdbcDataSource().createUxType());
        types.add(new UxBuilderUrlJdbcDataSource().createUxType());
        return types;
    }

    public OlapBuilderJdbcDataSource toUxEdition() {
        switch (this.driverType) {
            case AWS_REDSHIFT: {
                return new UxBuilderRedshiftJdbcDataSource(this);
            }
            case DB2: {
                return new UxBuilderDB2JdbcDataSource(this);
            }
            case MYSQL: {
                return new UxBuilderMySqlJdbcDataSource(this);
            }
            case ORACLE: {
                return new UxBuilderOracleJdbcDataSource(this);
            }
            case POSTGRES: {
                return new UxBuilderPostgresJdbcDataSource(this);
            }
            case SQLSERVER: {
                return new UxBuilderSqlServerJdbcDataSource(this);
            }
            case SYBASE_JTDS: {
                return new UxBuilderSybaseJdbcDataSource(this);
            }
            case TRINO: {
                return new UxBuilderTrinoJdbcDataSource(this);
            }
        }
        return new UxBuilderUrlJdbcDataSource(this);
    }

    public OlapBuilderJdbcDataSource fromUxEdition() {
        return this;
    }

    @Override
    protected OlapBuilderBaseDataSource createEmptyDataSource() {
        return new OlapBuilderJdbcDataSource(OlapBuilderDriverType.SERVER_AS_JDBCDRIVER_DBNAME_AS_JDBCURL);
    }

    @Override
    public void beforeMarshal() {
    }

    @Override
    public void afterUnmarshal() {
    }

    public String getStringDateConverter() {
        return this.stringDateConverter;
    }

    public Locale getStringConverterLocale() {
        return this.stringConverterLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends IOlapBuilderDataColumnDef> discoverColumnForTable(String tableName, OlapBuilderJdbcConnection openedConnection) throws SQLException {
        try {
            if (this.typedDataSource.isDiscoverColumnOnMetaSupported()) {
                List<? extends IOlapBuilderDataColumnDef> list = this.discoverColumnsForTableOnMeta(tableName, openedConnection);
                return list;
            }
            List<? extends IOlapBuilderDataColumnDef> list = this.discoverColumnsForTableOnQuery(tableName, openedConnection);
            return list;
        }
        finally {
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)("[DB] discovering columns for table [" + tableName + "] done"));
            }
        }
    }

    public static void addColumnsFromQueryMeta(List<IOlapBuilderDataColumnDef> columns, ResultSetMetaData meta, String tableName) throws SQLException {
        for (int idx = 1; idx <= meta.getColumnCount(); ++idx) {
            String columnName = meta.getColumnLabel(idx);
            int columnType = meta.getColumnType(idx);
            String columnTypeName = meta.getColumnTypeName(idx);
            int columnSize = meta.getPrecision(idx);
            int decimalDigits = meta.getScale(idx);
            OlapBuilderDataColumn column = OlapBuilderBaseJdbcDataTable.createDataTableColumn(tableName, columnName, columnType, columnTypeName, columnSize, decimalDigits);
            columns.add(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<? extends IOlapBuilderDataColumnDef> discoverColumnsForTableOnQuery(String tableName, OlapBuilderJdbcConnection openedConnection) throws SQLException {
        ArrayList<IOlapBuilderDataColumnDef> arrayList;
        Statement statement = null;
        ResultSet rs = null;
        try {
            ArrayList<IOlapBuilderDataColumnDef> columns = new ArrayList<IOlapBuilderDataColumnDef>();
            statement = openedConnection.getConnection().createStatement();
            rs = statement.executeQuery("SELECT * from " + openedConnection.getTableNameForSqlStatement(tableName) + " OFFSET 0 ROWS FETCH NEXT 1 ROWS ONLY");
            ResultSetMetaData meta = rs.getMetaData();
            OlapBuilderJdbcDataSource.addColumnsFromQueryMeta(columns, meta, tableName);
            arrayList = columns;
            this.afterDiscoverColumns(openedConnection);
        }
        catch (Throwable throwable) {
            this.afterDiscoverColumns(openedConnection);
            CdJdbcUtils.closeQuietly(statement);
            CdJdbcUtils.closeQuietly(rs);
            throw throwable;
        }
        CdJdbcUtils.closeQuietly((Statement)statement);
        CdJdbcUtils.closeQuietly((ResultSet)rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<? extends IOlapBuilderDataColumnDef> discoverColumnsForTableOnMeta(String tableName, OlapBuilderJdbcConnection openedConnection) throws SQLException {
        ArrayList<OlapBuilderDataColumn> arrayList;
        ResultSet rs = null;
        try {
            ArrayList<OlapBuilderDataColumn> columns = new ArrayList<OlapBuilderDataColumn>();
            DatabaseMetaData metaData = openedConnection.getMetaData();
            rs = this.getDbColumns(metaData, tableName);
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                String columnTypeName = rs.getString("TYPE_NAME");
                int columnType = rs.getInt("DATA_TYPE");
                int columnSize = rs.getInt("COLUMN_SIZE");
                int decimalDigits = rs.getInt("DECIMAL_DIGITS");
                OlapBuilderDataColumn column = OlapBuilderBaseJdbcDataTable.createDataTableColumn(tableName, columnName, columnType, columnTypeName, columnSize, decimalDigits);
                columns.add(column);
            }
            arrayList = columns;
            this.afterDiscoverColumns(openedConnection);
        }
        catch (Throwable throwable) {
            this.afterDiscoverColumns(openedConnection);
            CdJdbcUtils.closeQuietly(rs);
            throw throwable;
        }
        CdJdbcUtils.closeQuietly((ResultSet)rs);
        return arrayList;
    }
}

