/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc;

import crazydev.common.utils.CdJdbcUtils;
import crazydev.common.utils.CdOsUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.datasource.jdbc.IBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderJdbcConnection
extends OlapBuilderAbstractConnection<OlapBuilderJdbcDataSource>
implements IBuilderJdbcConnection,
AutoCloseable {
    private volatile boolean invalid = false;
    private Connection connection;
    private boolean rollback = false;

    public OlapBuilderJdbcConnection(OlapBuilderJdbcDataSource datasource) {
        super(datasource);
        if (OlapLoggers.JDBC.isDebugEnabled()) {
            OlapLoggers.JDBC.debug((Object)("[JDBC] creating a new MDX connection [" + System.identityHashCode(this) + "]"));
        }
    }

    @Override
    protected void checkOnOpenConnectionEx() throws OlapBuilderErrorException {
        if (((OlapBuilderJdbcDataSource)this.dataSource).isTrino()) {
            try {
                DatabaseMetaData meta = this.getMetaData();
                ResultSet rs = meta.getCatalogs();
                try {
                    rs.close();
                }
                finally {
                    CdJdbcUtils.closeQuietly((ResultSet)rs);
                }
            }
            catch (SQLException ex) {
                OlapLoggers.BUILDER.error((Object)"Trino connection error", (Throwable)ex);
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{ex.getMessage()});
            }
        }
    }

    public void markAsInvalid() {
        this.invalid = true;
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.assertIsOpen();
        return this.connection.getMetaData();
    }

    public Connection createWriteConnection() throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException, InvocationTargetException, NoSuchMethodException {
        this.loadJdbcDriverClass(((OlapBuilderJdbcDataSource)this.dataSource).getDriverName());
        if (OlapLoggers.JDBC.isDebugEnabled()) {
            OlapLoggers.JDBC.debug((Object)("[JDBC] opening a new write DB connection [" + System.identityHashCode(this) + "]"));
        }
        Connection conn = this.createJdbcConnection(((OlapBuilderJdbcDataSource)this.dataSource).getOrCreateURL(), ((OlapBuilderJdbcDataSource)this.dataSource).getOrCreateParams());
        conn.setAutoCommit(false);
        if (conn instanceof OracleConnection) {
            OracleConnection oracleConnection = (OracleConnection)conn;
            oracleConnection.setRemarksReporting(false);
            if (((OlapBuilderJdbcDataSource)this.dataSource).isIncludeSynonyms()) {
                OlapLoggers.JDBC.debug((Object)"[JDBC] including synonyms");
                oracleConnection.setIncludeSynonyms(true);
            }
        }
        return conn;
    }

    @Override
    protected void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException {
        try {
            boolean isJdbcAutoCommitFalseActivated;
            this.loadJdbcDriverClass(((OlapBuilderJdbcDataSource)this.dataSource).getDriverName());
            if (OlapLoggers.JDBC.isDebugEnabled()) {
                OlapLoggers.JDBC.debug((Object)("[JDBC] opening a new DB connection [" + System.identityHashCode(this) + "]"));
            }
            if (((OlapBuilderJdbcDataSource)this.dataSource).isAccessJdk() && !CdOsUtils.isWindows()) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.JDBC_DRIVER_NOT_FOUND, new Serializable[]{((OlapBuilderJdbcDataSource)this.dataSource).getDriverName()});
            }
            this.connection = this.createJdbcConnection(((OlapBuilderJdbcDataSource)this.dataSource).getOrCreateURL(), ((OlapBuilderJdbcDataSource)this.dataSource).getOrCreateParams());
            Connection connection = this.connection;
            if (connection instanceof OracleConnection) {
                OracleConnection oracleConnection = (OracleConnection)connection;
                oracleConnection.setRemarksReporting(false);
                if (((OlapBuilderJdbcDataSource)this.dataSource).isIncludeSynonyms()) {
                    OlapLoggers.JDBC.debug((Object)"[JDBC] including synonyms");
                    oracleConnection.setIncludeSynonyms(true);
                }
            }
            boolean bl = isJdbcAutoCommitFalseActivated = !((OlapBuilderJdbcDataSource)this.dataSource).disableAutoCommitFalse();
            if (isJdbcAutoCommitFalseActivated && ((OlapBuilderJdbcDataSource)this.dataSource).getOrCreateTypedDataSource().supportsAutoCommit()) {
                OlapLoggers.JDBC.debug((Object)"[JDBC] setAutoCommit false (rollback)");
                this.connection.setAutoCommit(false);
                this.rollback = true;
            }
            try {
                if (!((OlapBuilderJdbcDataSource)this.dataSource).disableReadOnlyMode() && !this.connection.isReadOnly()) {
                    this.connection.setReadOnly(true);
                }
            }
            catch (SQLFeatureNotSupportedException ignored) {
                if (OlapLoggers.JDBC.isDebugEnabled()) {
                    OlapLoggers.JDBC.debug((Object)"[JDBC] DB connection readonly mode could not be activated");
                }
            }
        }
        catch (ClassNotFoundException ex) {
            throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.JDBC_DRIVER_NOT_FOUND, new Serializable[]{((OlapBuilderJdbcDataSource)this.dataSource).getDriverName()});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.JDBC_DRIVER_CANNOT_BE_INSTANTIATED, new Serializable[]{((OlapBuilderJdbcDataSource)this.dataSource).getDriverName()});
        }
        catch (SQLException ex) {
            String message = ex.getLocalizedMessage();
            String userName = ((OlapBuilderJdbcDataSource)this.dataSource).getUserEx();
            throw new OlapBuilderErrorException(ex, OlapBuilderErrorCode.JDBC_CONNECTION_CANNOT_BE_CREATED, new Serializable[]{((OlapBuilderJdbcDataSource)this.dataSource).getOrCreateURL(), userName == null ? "" : userName, message == null ? ex.toString() : ex});
        }
    }

    protected void loadJdbcDriverClass(String driverClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (CdStringUtils.isNotNullAndNotBlank((String)driverClassName)) {
            Class.forName(driverClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    protected Connection createJdbcConnection(String url, Properties info) throws SQLException {
        return DriverManager.getConnection(url, info);
    }

    @Override
    protected void onClose() {
        if (OlapLoggers.JDBC.isDebugEnabled()) {
            OlapLoggers.JDBC.debug((Object)("[JDBC] closing the DB connection [" + System.identityHashCode(this) + "]"));
        }
        CdJdbcUtils.closeQuietly((Connection)this.connection, (boolean)this.rollback);
        this.connection = null;
    }

    public String getTableNameForSqlStatement(String name) throws SQLException {
        this.assertIsOpen();
        return ((OlapBuilderJdbcDataSource)this.dataSource).getEntityNameForSqlStatement(this.connection.getMetaData(), name, true);
    }

    public String getColumnNameForSqlStatement(String name) throws SQLException {
        this.assertIsOpen();
        return ((OlapBuilderJdbcDataSource)this.dataSource).getEntityNameForSqlStatement(this.connection.getMetaData(), name, false);
    }

    @Override
    @Nullable
    public PreparedStatement createStatement(String sql, int fetchSize) throws SQLException {
        this.assertIsOpen();
        PreparedStatement statement = this.connection.prepareStatement(sql, 1003, 1007);
        if (((OlapBuilderJdbcDataSource)this.dataSource).isMySql()) {
            statement.setFetchSize(Integer.MIN_VALUE);
        } else if (!((OlapBuilderJdbcDataSource)this.dataSource).isAccessJdk()) {
            statement.setFetchSize(fetchSize);
        }
        return statement;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }
}

