/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.jdbc;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdJdbcUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcConnection;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataSource;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataTable;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderJdbcDataTableFullRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.sql.SQLException;
import java.util.List;

public abstract class OlapBuilderBaseJdbcDataTable
extends OlapBuilderBaseDataTable<OlapBuilderJdbcConnection> {
    public static final int DEFAULT_FETCH_SIZE = 1000;
    public static final CdProperty FETCH_SIZE = new CdReadWriteProperty(OlapBuilderJdbcDataTable.class, "fetchSize");
    @XmlAttribute(required=true)
    protected int fetchSize = 1000;

    public OlapBuilderBaseJdbcDataTable() {
    }

    public OlapBuilderBaseJdbcDataTable(int defaultFetchSize) {
        this.fetchSize = defaultFetchSize;
    }

    public OlapBuilderBaseJdbcDataTable(String tableName, int defaultFetchSize) {
        super(tableName);
        this.fetchSize = defaultFetchSize;
    }

    public OlapBuilderBaseJdbcDataTable(String tableName, List<IOlapBuilderDataColumnDef> columns) {
        super(tableName, columns);
    }

    public OlapBuilderJdbcDataTableFullRowReader __createFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return this.doCreateFullTableRowReader(context, connectionPool, maxRowCount);
    }

    protected OlapBuilderJdbcDataTableFullRowReader doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new OlapBuilderJdbcDataTableFullRowReader(context, connectionPool, maxRowCount, this);
    }

    protected abstract String createSelectStatement(OlapBuilderJdbcConnection var1, boolean var2) throws SQLException;

    protected String getIncrementalWhereClause(OlapBuilderJdbcConnection connection) throws SQLException {
        String col = this.getIncrementalLoadColumnName();
        String col_ = connection.getColumnNameForSqlStatement(col);
        return "WHERE " + col_ + " > ?";
    }

    protected static OlapBuilderDataColumn createDataTableColumn(String tableName, String columnName, int columnType, String columnTypeName, int columnSize, int decimalDigits) {
        if (columnType == 2003) {
            return OlapBuilderBaseJdbcDataTable.asArrayColumn(columnName, columnTypeName);
        }
        OlapBuilderInputType inputType = OlapBuilderInputType.findByDBType(columnType, columnSize, decimalDigits);
        if (inputType == OlapBuilderInputType.DB_TYPE_UNSUPPORTED) {
            OlapLoggers.BUILDER_TABLE.warn((Object)("DB type not supported [tableName:" + tableName + "] [columnName:" + columnName + "] [java.sql.Type:" + columnType + "]"));
        }
        Object columnTypeAsString = CdJdbcUtils.getJdbcTypeName((int)columnType);
        if (2 == columnType || 3 == columnType) {
            columnTypeAsString = (String)columnTypeAsString + "(" + columnSize + "," + decimalDigits + ")";
        } else if (OlapBuilderInputType.STRING == inputType && columnSize != Integer.MAX_VALUE) {
            columnTypeAsString = (String)columnTypeAsString + "(" + columnSize + ")";
        }
        return new OlapBuilderDataColumn(inputType, (String)columnTypeAsString, columnName);
    }

    private static OlapBuilderDataColumn asArrayColumn(String columnName, String columnTypeName) {
        OlapBuilderInputType inputType = OlapBuilderBaseJdbcDataTable.bestEffortOnArrayType(columnTypeName);
        return new OlapBuilderDataColumn(inputType, "ARRAY(" + columnTypeName + ")", columnName, true);
    }

    private static OlapBuilderInputType bestEffortOnArrayType(String columnTypeName) {
        if (columnTypeName.contains("float4")) {
            return OlapBuilderInputType.FLOAT;
        }
        if (columnTypeName.contains("int2") || columnTypeName.contains("smallint")) {
            return OlapBuilderInputType.SHORT;
        }
        if (columnTypeName.contains("float")) {
            return OlapBuilderInputType.DOUBLE;
        }
        if (columnTypeName.contains("int")) {
            return OlapBuilderInputType.INTEGER;
        }
        return OlapBuilderInputType.STRING;
    }

    @Override
    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumnsForRefresh(OlapRuntimeContext context, OlapBuilderJdbcConnection connection, OlapBuilderErrorManager errorManager) {
        return this.discoverAllColumns(context, connection, errorManager);
    }

    public OlapBuilderJdbcDataSource getTypedDataSource() {
        return (OlapBuilderJdbcDataSource)this.getDataSource();
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }
}

