/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.file;

import crazydev.common.utils.CdLineReader;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.file.OlapBuilderBaseFileDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderBaseLineDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderDirectoryConnection;
import crazydev.iccube.builder.datasource.file.OlapBuilderFileTablePartitionKey;
import crazydev.iccube.builder.datasource.file.OlapBuilderLineDataTableRowReader;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderPartitionedLineDataTableRowReader
extends OlapBuilderLineDataTableRowReader<OlapBuilderDirectoryConnection> {
    private final OlapBuilderFileTablePartitionKey partitionedKey;

    public OlapBuilderPartitionedLineDataTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderBaseLineDataTable<OlapBuilderDirectoryConnection> table, String fullNameForEndUser, OlapBuilderFileTablePartitionKey partitionedKey) {
        super(context, connectionPool, maxRowCount, table, fullNameForEndUser);
        this.partitionedKey = partitionedKey;
    }

    @Override
    public String getName() {
        return this.partitionedKey.getName();
    }

    @Override
    @Nullable
    public IOlapBuilderTablePartitionKey getPartitionKey() {
        return this.partitionedKey;
    }

    @Override
    Object getPartitioningValue(String currentFileName) {
        return this.partitionedKey.getStrValue();
    }

    @Override
    CdLineReader createLineReader() {
        OlapBuilderBaseFileDataTable table = (OlapBuilderBaseFileDataTable)this.table;
        Predicate<String> firstFilter = table.getFileFilter();
        Predicate<String> predicate = fileName -> firstFilter.test((String)fileName) && this.partitionedKey.matches((String)fileName);
        CdLineReader lineReader = ((OlapBuilderDirectoryConnection)this.connection).createMultiFileReader(this.context.asRuntimeContext(), table.getName(), table.isFileNameSorted(), predicate, table.getFileEncoding());
        return lineReader;
    }
}

