/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.file;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.datasource.file.OlapBuilderBaseLineDataTable;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderNonEmptyDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderLineDataTable<CONNECTION extends OlapBuilderAbstractConnection>
extends OlapBuilderBaseLineDataTable<CONNECTION> {
    public static final CdProperty COLUMN_SEPARATOR = new CdReadWriteProperty(OlapBuilderLineDataTable.class, "columnSeparator");
    public static final CdProperty COMMENT_MARKER = new CdReadWriteProperty(OlapBuilderLineDataTable.class, "commentMarker");
    @XmlElement(required=true)
    private String columnSeparator;
    @XmlElement(required=false)
    @Nullable
    private String commentMarker;
    @XmlTransient
    private boolean withHeader = true;

    protected OlapBuilderLineDataTable() {
    }

    protected OlapBuilderLineDataTable(String tableName, String columnSeparator, String commentMarker, boolean withHeader) {
        super(tableName);
        this.commentMarker = commentMarker;
        this.columnSeparator = columnSeparator;
        this.withHeader = withHeader;
    }

    public OlapBuilderLineDataTable(String tableName) {
        this(tableName, ",", "#", true);
    }

    @Override
    @Nullable
    public String getCommentMarker() {
        return this.commentMarker;
    }

    public void setCommentMarker(String commentMarker) {
        this.commentMarker = commentMarker;
    }

    @Override
    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    @Override
    public String getArrayValueSeparator() {
        return ",".equals(this.getColumnSeparator()) ? ";" : ",";
    }

    @Override
    public boolean isWithHeader() {
        return this.withHeader;
    }

    public void setWithHeader(boolean withHeader) {
        this.withHeader = withHeader;
    }

    @Override
    public OlapBuilderValidator<IOlapBuilderDataSource<CONNECTION>, IOlapBuilderDataTableDef<CONNECTION>> getValidator() {
        return new OlapBuilderNonEmptyDataTableValidator(this.withHeader);
    }

    @Override
    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable) {
        return true;
    }
}

