/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.file;

import crazydev.iccube.builder.datasource.file.OlapBuilderAbstractFileDataSource;
import crazydev.iccube.builder.datasource.file.OlapBuilderDirectoryConnection;
import crazydev.iccube.builder.datasource.file.OlapBuilderFileLineDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderHttpFileLineDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderMultiFileLineDataTable;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="fileDS")
public class OlapBuilderFileDataSource
extends OlapBuilderAbstractFileDataSource<OlapBuilderDirectoryConnection> {
    static final List<Class<? extends IOlapBuilderTabularDataDef>> CREATED_TABLE_TYPES_HTTP = Arrays.asList(OlapBuilderHttpFileLineDataTable.class);
    static final List<Class<? extends IOlapBuilderTabularDataDef>> CREATED_TABLE_TYPES = Arrays.asList(OlapBuilderMultiFileLineDataTable.class);

    public OlapBuilderFileDataSource() {
    }

    public OlapBuilderFileDataSource(String directory) {
        this((File)null, directory);
    }

    public OlapBuilderFileDataSource(@Nullable File xmlFile, String directory) {
        super(xmlFile, directory);
    }

    @Override
    protected String getReportDataSourceType() {
        return "files";
    }

    @Override
    protected String getReportDataSourceTypeCaption() {
        return "Files";
    }

    @Override
    @Nullable
    public List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes() {
        return this.isHttp() ? CREATED_TABLE_TYPES_HTTP : CREATED_TABLE_TYPES;
    }

    @Override
    public OlapBuilderBaseDataTable<OlapBuilderDirectoryConnection> createEmptyDiscoverTable(String tableName) {
        return new OlapBuilderFileLineDataTable(tableName);
    }

    @Override
    public OlapBuilderBaseDataTable<OlapBuilderDirectoryConnection> createEmptyCreateTable(@Nullable Class<IOlapBuilderTabularDataDef> tableType) {
        OlapBuilderFileLineDataTable table;
        if (OlapBuilderHttpFileLineDataTable.class.equals(tableType)) {
            table = new OlapBuilderHttpFileLineDataTable();
        } else if (OlapBuilderMultiFileLineDataTable.class.equals(tableType)) {
            table = new OlapBuilderMultiFileLineDataTable();
        } else {
            throw new RuntimeException("internal error : unexpected table type [" + (tableType != null ? tableType.getSimpleName() : "n/a") + "]");
        }
        return table;
    }
}

