/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.file;

import crazydev.common.utils.CdLineReader;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.builder.common.OlapAbstractFileSystem;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.fs.OlapFileNameFilter;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderDirectoryConnection<DATASOURCE extends OlapBuilderBaseDataSource>
extends OlapBuilderAbstractConnection<DATASOURCE> {
    private OlapAbstractFileSystem fileSystem;

    public OlapBuilderDirectoryConnection(DATASOURCE datasource, OlapAbstractFileSystem fileSystem) {
        super(datasource);
        this.fileSystem = fileSystem;
    }

    @Override
    protected void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException {
        this.fileSystem.onOpen(context);
    }

    public OlapAbstractFileSystem getUnderlyingFS() {
        return this.fileSystem;
    }

    public boolean isFileExist(OlapRuntimeContext context, String untrustedFileName) {
        return this.fileSystem.fileExists(context, untrustedFileName);
    }

    public CdLineReader createSingleFileReader(OlapRuntimeContext context, String untrustedFileName, String fileEncoding) {
        this.assertIsOpen();
        return this.fileSystem.createSingleFileReader(context, untrustedFileName, fileEncoding);
    }

    @Nullable
    public CdLineReader createMultiFileReader(OlapRuntimeContext context, String tableName, boolean sorted, @Nullable Predicate<String> fileFilter, String fileEncoding) {
        long startNS = System.nanoTime();
        this.assertIsOpen();
        CdLineReader reader = this.fileSystem.createMultiFileReader(context, sorted, fileFilter, fileEncoding);
        if (OlapLoggers.BUILDER.isDebugEnabled()) {
            OlapLoggers.BUILDER.debug((Object)("[builder] create multi-file reader for table [" + tableName + "] in " + CdTimeUtils.formatNanosEx((long)startNS)));
        }
        return reader;
    }

    public String getUnderlyingAbsolutePathForUserError(OlapRuntimeContext context, String untrustedFileName) {
        return this.fileSystem.getUnderlyingAbsolutePathForUserError(context, untrustedFileName);
    }

    public List<String> listLocalFileNames(OlapFileNameFilter filter) {
        return this.fileSystem.listLocalFileNames(filter);
    }

    @Override
    protected void onClose() {
        this.fileSystem.onClose();
        this.fileSystem = null;
    }
}

