/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.file;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdLineReader;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.common.IOlapBuilderLineReaderTable;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableRequestedPartitionKeys;
import crazydev.iccube.builder.datasource.file.OlapBuilderAbstractFileDataSource;
import crazydev.iccube.builder.datasource.file.OlapBuilderDirectoryConnection;
import crazydev.iccube.builder.datasource.file.OlapBuilderFileLineDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderFileTablePartitionKey;
import crazydev.iccube.builder.datasource.file.OlapBuilderLineDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderPartitionedLineDataTableRowReader;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderBaseFileDataTable
extends OlapBuilderLineDataTable<OlapBuilderDirectoryConnection>
implements IOlapBuilderLineReaderTable {
    public static final CdProperty FILE_ENCODING = new CdReadWriteProperty(OlapBuilderFileLineDataTable.class, "fileEncoding");
    public static final CdProperty PARTITIONING_STRATEGY = new CdReadWriteProperty(OlapBuilderFileLineDataTable.class, "partitioningStrategy"){

        public boolean isForPartitioning() {
            return true;
        }
    };
    @XmlAttribute(required=true)
    private String fileEncoding = "UTF-8";
    @XmlAttribute(required=false)
    @Nullable
    private String partitioningStrategy;

    public OlapBuilderBaseFileDataTable() {
    }

    public OlapBuilderBaseFileDataTable(String tableName) {
        super(tableName);
    }

    public OlapBuilderBaseFileDataTable(String tableName, String columnSeparator, String commentMarker, boolean withHeader) {
        super(tableName, columnSeparator, commentMarker, withHeader);
    }

    protected static String asTableName(String fileName) {
        return fileName;
    }

    @Override
    public boolean isNameReadOnly() {
        return this.getName() != null;
    }

    @Nullable
    public String getPartitioningStrategy() {
        return this.partitioningStrategy;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    @Override
    public boolean checkColumnSize() {
        IOlapBuilderDataSource ds = this.getDataSource();
        if (ds instanceof OlapBuilderAbstractFileDataSource) {
            OlapBuilderAbstractFileDataSource dataSource = (OlapBuilderAbstractFileDataSource)ds;
            return dataSource.checkColumnSize();
        }
        return false;
    }

    @Override
    public CdLineReader createLineReader(OlapRuntimeContext context, OlapBuilderDirectoryConnection openedConnection) {
        if (this.isSingleFile()) {
            String fileName = this.getFileNameForStream();
            return openedConnection.createSingleFileReader(context, fileName, this.fileEncoding);
        }
        CdLineReader reader = openedConnection.createMultiFileReader(context, this.getName(), this.isFileNameSorted(), this.getFileFilter(), this.fileEncoding);
        if (reader == null) {
            String fileFilter = this.getFileNameForStream();
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.NO_FILES_FOUND_FOR_FILTER, new Serializable[]{fileFilter});
        }
        return reader;
    }

    @Override
    public String getFullNameForEndUser(OlapRuntimeContext context, OlapBuilderDirectoryConnection connection) {
        return connection.getUnderlyingAbsolutePathForUserError(context, this.getFileName());
    }

    @Override
    @Nullable
    protected IOlapBuilderTableRowReader createRowReaderForTableCacheRead(OlapBuilderContext context) {
        return null;
    }

    @Override
    protected IOlapBuilderTableRowReader decorateRowReaderForTableCache(OlapBuilderContext context, IOlapBuilderTableRowReader reader) {
        return reader;
    }

    protected String getFileNameForStream() {
        return this.getFileName();
    }

    public boolean isSingleFile() {
        return true;
    }

    @Override
    public boolean hasTablePartitioning() {
        return !this.isSingleFile() && CdStringUtils.isNotNullAndNotBlank((String)this.partitioningStrategy);
    }

    @Override
    @Nullable
    public String getPartitioningColumnName() {
        return this.hasTablePartitioning() ? "ic3-Partition" : null;
    }

    @Override
    public void setPartitioningColumnName(@Nullable String partitioningColumnName) {
        super.setPartitioningColumnName(partitioningColumnName);
    }

    @Override
    boolean shouldCreatePartitionColumn() {
        return this.hasTablePartitioning();
    }

    @Override
    public boolean isPartitioningColumn(IOlapBuilderDataColumnDef column) {
        return this.hasTablePartitioning() && "ic3-Partition".equals(column.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<IOlapBuilderTablePartitionKey> doGetPartitionKeys(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, @Nullable OlapBuilderTableRequestedPartitionKeys requestedPartitions) {
        long startNS = System.nanoTime();
        try {
            CdLineReader lineReader;
            OlapBuilderDirectoryConnection connection;
            block14: {
                ArrayList<IOlapBuilderTablePartitionKey> rKeys;
                if (requestedPartitions != null) {
                    rKeys = new ArrayList();
                    PartitionExtractor extractor = this.createPartitionExtractor();
                    for (String key : requestedPartitions.getKeys()) {
                        rKeys.add(new OlapBuilderFileTablePartitionKey(extractor, key));
                    }
                    context.setRequestedTablePartitionKeys(this, rKeys);
                }
                if (CdStringUtils.isNullOrBlank((String)this.partitioningStrategy)) {
                    rKeys = Collections.emptyList();
                    return rKeys;
                }
                connection = (OlapBuilderDirectoryConnection)connectionPool.getOrCreateOpenedConnection(context.asRuntimeContext(), this.getDataSource());
                try {
                    lineReader = this.createLineReader(context.asRuntimeContext(), connection);
                    if (lineReader != null) break block14;
                    List list = Collections.emptyList();
                    connectionPool.releaseOpenedConnection(connection);
                    return list;
                }
                catch (Throwable throwable) {
                    connectionPool.releaseOpenedConnection(connection);
                    throw throwable;
                }
            }
            HashSet<String> partitions = new HashSet<String>();
            PartitionExtractor extractor = this.createPartitionExtractor();
            lineReader.forEachFileName(fileName -> partitions.add(extractor.extract((String)fileName)));
            if (requestedPartitions != null) {
                partitions.removeIf(partition -> !requestedPartitions.getKeys().contains(partition));
            }
            ArrayList<IOlapBuilderTablePartitionKey> keys = new ArrayList<IOlapBuilderTablePartitionKey>();
            partitions.forEach(partition -> keys.add(new OlapBuilderFileTablePartitionKey(extractor, (String)partition)));
            ArrayList<IOlapBuilderTablePartitionKey> arrayList = keys;
            connectionPool.releaseOpenedConnection(connection);
            return arrayList;
        }
        finally {
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)("[builder] partition-keys for table [" + this.getName() + "] in " + CdTimeUtils.formatNanosEx((long)startNS)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderDirectoryConnection> doCreatePartitionTableRowReaders(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, IOlapBuilderTablePartitionKey partitionKey) {
        OlapBuilderDirectoryConnection connection = (OlapBuilderDirectoryConnection)connectionPool.getOrCreateOpenedConnection(context.asRuntimeContext(), this.getDataSource());
        try {
            String fullNameForEndUser = this.getFullNameForEndUser(context.asRuntimeContext(), connection);
            OlapBuilderPartitionedLineDataTableRowReader olapBuilderPartitionedLineDataTableRowReader = new OlapBuilderPartitionedLineDataTableRowReader(context, connectionPool, -1, this, fullNameForEndUser, (OlapBuilderFileTablePartitionKey)partitionKey);
            return olapBuilderPartitionedLineDataTableRowReader;
        }
        finally {
            connectionPool.releaseOpenedConnection(connection);
        }
    }

    @Override
    @Nullable
    public String getPartitioningColumnNameX() {
        return this.getPartitioningColumnName();
    }

    @Override
    @Nullable
    public String getPartitioningColumnNameTableX() {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public Object calculatePartition(String currentFileName) {
        if (this.isSingleFile()) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        return this.createPartitionExtractor().extract(currentFileName);
    }

    public PartitionExtractor createPartitionExtractor() {
        if (".*".equals(this.partitioningStrategy)) {
            return fileName -> fileName;
        }
        Pattern pattern = Pattern.compile(this.partitioningStrategy);
        return fileName -> {
            Matcher matcher = pattern.matcher(fileName);
            StringBuilder builder = new StringBuilder();
            while (matcher.find()) {
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    builder.append(matcher.group(1 + i));
                }
            }
            String toString = builder.toString();
            if (toString.isEmpty()) {
                throw new OlapBuilderErrorException(OlapBuilderErrorCode.WRONG_PARTITION_STRATEGY, new Serializable[]{this.partitioningStrategy, fileName});
            }
            return toString;
        };
    }

    public Predicate<String> getFileFilter() {
        if (this.isSingleFile()) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        String fileFilter = this.getFileNameForStream();
        return OlapBuilderBaseFileDataTable.filterAsPredicate(fileFilter);
    }

    @NotNull
    public static Predicate<String> filterAsPredicate(String fileFilter) {
        if (CdStringUtils.isNullOrBlank((String)fileFilter)) {
            return fileName -> true;
        }
        Pattern pattern = Pattern.compile(fileFilter);
        return fileName -> pattern.matcher((CharSequence)fileName).matches();
    }

    @FunctionalInterface
    public static interface PartitionExtractor {
        public String extract(String var1);
    }
}

