/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.facts;

import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataViewLinks;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.HashMap;
import java.util.List;

@XmlRootElement(name="link")
public final class OlapBuilderLinkXmlDefinition {
    @XmlAttribute(required=true)
    private final String dimensionId;
    @XmlElement(name="viewLinks", required=true, type=OlapBuilderDataViewLinks.class)
    private final IOlapBuilderDataViewLinksDef link;

    private OlapBuilderLinkXmlDefinition() {
        this(null, "?", null);
    }

    public OlapBuilderLinkXmlDefinition(String dimensionId, String dimensionName, IOlapBuilderDataViewLinksDef link) {
        this.dimensionId = dimensionId;
        this.link = link;
    }

    public String getDimensionId() {
        return this.dimensionId;
    }

    public IOlapBuilderDataViewLinksDef getLink() {
        return this.link;
    }

    public boolean isEmpty() {
        return this.link == null || this.link.isEmpty();
    }

    public static void sort(List<OlapBuilderLinkXmlDefinition> links, List<IOlapBuilderDimensionDef> dimensions) {
        HashMap<String, Integer> dimensionPositions = new HashMap<String, Integer>();
        for (int ii = 0; ii < dimensions.size(); ++ii) {
            IOlapBuilderDimensionDef dim = dimensions.get(ii);
            dimensionPositions.put(dim.getId(), ii);
        }
        boolean ok = true;
        for (OlapBuilderLinkXmlDefinition link : links) {
            if (link.dimensionId != null && dimensionPositions.containsKey(link.dimensionId)) continue;
            ok = false;
            break;
        }
        if (!ok) {
            return;
        }
        links.sort((l1, l2) -> {
            Integer p2;
            Integer p1 = l1.dimensionId != null ? (Integer)dimensionPositions.get(l1.dimensionId) : null;
            Integer n = p2 = l2.dimensionId != null ? (Integer)dimensionPositions.get(l2.dimensionId) : null;
            if (p1 != null && p2 != null) {
                return Integer.compare(p1, p2);
            }
            return 0;
        });
    }

    public String toString() {
        return this.link.getType().name() + " : " + this.dimensionId;
    }
}

