/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.facts;

import crazydev.iccube.builder.OlapBuilderReferenceSolver;
import crazydev.iccube.builder.datasource.facts.OlapBuilderLinkXmlDefinition;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.errors.OlapBuilderErrorManagerHelper;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.model.builders.IOlapBuilderChangeDefinitionListener;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.IOlapBuilderValidationEnabled;
import crazydev.iccube.builder.model.def.OlapBuilderDataViewLinksType;
import crazydev.iccube.builder.model.impl.OlapBuilderMeasure;
import crazydev.iccube.builder.model.impl.OlapBuilderNamedDefinitionHelper;
import crazydev.iccube.cluster.shared.schema.S_DimensionDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.enums.OlapFactRowAggregationType;
import crazydev.iccube.enums.OlapUnresolvedRowsBehavior;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import jakarta.xml.bind.annotation.XmlAccessOrder;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorOrder;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlAccessorOrder(value=XmlAccessOrder.ALPHABETICAL)
public abstract class OlapBuilderBaseFacts<T extends IOlapBuilderTabularDataDef, PARENT extends IOlapBuilderValidationEnabled, P extends IOlapBuilderBaseFactsDef>
implements IOlapBuilderBaseFactsDef<PARENT, P>,
IOlapBuilderJaxbListener {
    @XmlAttribute(required=false)
    private Boolean newGeneration;
    @XmlAttribute(name="dataTableId")
    private String dataTableId;
    @XmlAttribute(name="aggregateDataSourceFacts", required=false)
    private boolean aggregateDataSourceFacts;
    @XmlElement(required=false)
    private OlapFactRowAggregationType rowFactAggregationType;
    @XmlAttribute(name="unresolvedRowsBehavior", required=false)
    private OlapUnresolvedRowsBehavior unresolvedRowsBehavior = OlapUnresolvedRowsBehavior.ERROR;
    @XmlElementRefs(value={@XmlElementRef(name="measure", type=OlapBuilderMeasure.class)})
    private List<IOlapBuilderMeasureDef> measures;
    @XmlElement(required=false)
    private Boolean disableReverseLink;
    @XmlElement
    private List<OlapBuilderLinkXmlDefinition> links = new ArrayList<OlapBuilderLinkXmlDefinition>();
    @XmlTransient
    private Map<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef> dimensionMap = new HashMap<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef>();
    @XmlTransient
    private Map<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef> dimensionNotMap = new HashMap<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef>();
    @XmlTransient
    private T dataView;
    @XmlTransient
    @Nullable
    private IOlapBuilderCubeDef cube;

    public OlapBuilderBaseFacts() {
    }

    public OlapBuilderBaseFacts(boolean aggregateDataSourceFacts, List<IOlapBuilderMeasureDef> measures) {
        this.setAggrType(aggregateDataSourceFacts);
        this.measures = measures;
    }

    @Override
    public void beforeMarshal() {
        this.newGeneration = true;
    }

    @Override
    public void beforeMarshal(List<IOlapBuilderDimensionDef> dimensions) {
        OlapBuilderLinkXmlDefinition.sort(this.links, dimensions);
    }

    @Override
    public void afterUnmarshal() {
        if (this.newGeneration == null) {
            this.newGeneration = false;
        }
        if (this.rowFactAggregationType == null) {
            this.setAggrType(this.aggregateDataSourceFacts);
        }
    }

    @Override
    public boolean isNewGeneration() {
        return this.newGeneration == null || this.newGeneration != false;
    }

    @Override
    public Set<S_DimensionDef> getDimensionsWithReverseIndex(S_SchemaDef cSchema) {
        return Collections.emptySet();
    }

    @Override
    public boolean definesDimension(IOlapBuilderDimensionDef dimension) {
        String dimensionId = dimension.getId();
        for (OlapBuilderLinkXmlDefinition link : this.links) {
            if (!link.getDimensionId().equals(dimensionId)) continue;
            return true;
        }
        return false;
    }

    private void setAggrType(boolean aggregateDataSourceFacts) {
        this.rowFactAggregationType = aggregateDataSourceFacts ? OlapFactRowAggregationType.SUM_ON_CELL : OlapFactRowAggregationType.ADD_ROW;
    }

    @Override
    public OlapUnresolvedRowsBehavior getUnresolvedRowsBehavior() {
        return this.unresolvedRowsBehavior == null ? OlapUnresolvedRowsBehavior.ERROR : this.unresolvedRowsBehavior;
    }

    public void addLink(IOlapBuilderDimensionDef dimension, IOlapBuilderDataViewLinksDef linksDef) {
        if (linksDef != null && linksDef.getType() == OlapBuilderDataViewLinksType.NOT_MAPPED) {
            this.dimensionNotMap.put(dimension, linksDef);
        } else {
            this.dimensionMap.put(dimension, linksDef);
        }
        this.links.add(new OlapBuilderLinkXmlDefinition(dimension.getId(), dimension.getName(), linksDef));
    }

    public void removeLink(IOlapBuilderDimensionDef dimension) {
        OlapBuilderLinkXmlDefinition linkToRemove = null;
        for (OlapBuilderLinkXmlDefinition link : this.links) {
            if (!dimension.getId().equals(link.getDimensionId())) continue;
            linkToRemove = link;
            break;
        }
        if (linkToRemove != null) {
            this.links.remove(linkToRemove);
        }
        this.dimensionMap.remove(dimension);
        this.dimensionNotMap.remove(dimension);
    }

    public List<OlapBuilderLinkXmlDefinition> getLinks() {
        return this.links;
    }

    public void setLinks(List<OlapBuilderLinkXmlDefinition> links) {
        this.links = links;
        this.dimensionMap.clear();
        this.dimensionNotMap.clear();
    }

    @Override
    public Map<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef> getDimensionMap() {
        return this.dimensionMap;
    }

    @Override
    public boolean containsDimension(String name) {
        for (IOlapBuilderDimensionDef dimensionDef : this.dimensionMap.keySet()) {
            String dimName = dimensionDef.getName();
            if (!OlapCaseInsensitiveName.equals(dimName, name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDataTableId() {
        return this.dataTableId;
    }

    public void setDataTableId(String dataTableId) {
        this.dataTableId = dataTableId;
    }

    public T getDataView() {
        return this.dataView;
    }

    public void setDataView(T dataView) {
        this.dataView = dataView;
        this.dataTableId = dataView == null ? null : dataView.getId();
    }

    @Override
    public OlapFactRowAggregationType rowFactAggregationType() {
        return this.rowFactAggregationType;
    }

    @Override
    public IOlapBuilderMeasureDef createEmptyMeasure() {
        return new OlapBuilderMeasure();
    }

    @Override
    public void addOrUpdateMeasureForUx(IOlapBuilderMeasureDef measure) {
        if (this.measures == null) {
            this.measures = new ArrayList<IOlapBuilderMeasureDef>();
        }
        this.measures.remove(this.getDefinedMeasure(measure.getName()));
        this.measures.add(measure);
    }

    @Override
    public void removeMeasureForUX(IOlapBuilderMeasureDef measure) {
        if (this.measures != null) {
            this.measures.remove(measure);
        }
    }

    @Override
    @Nullable
    public IOlapBuilderMeasureDef getDefinedMeasure(String name) {
        if (this.measures != null) {
            for (IOlapBuilderMeasureDef measure : this.measures) {
                if (!measure.getName().equalsIgnoreCase(name)) continue;
                return measure;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IOlapBuilderMeasureDef getDefinedMeasureByUUID(String uuid) {
        if (this.measures != null) {
            for (IOlapBuilderMeasureDef measure : this.measures) {
                if (!measure.getUUID().equals(uuid)) continue;
                return measure;
            }
        }
        return null;
    }

    @Override
    public List<IOlapBuilderMeasureDef> getDefinedMeasures() {
        return this.measures;
    }

    public void setDefinedMeasures(List<IOlapBuilderMeasureDef> measures) {
        this.measures = measures;
    }

    @Override
    public boolean orderMeasures(List<String> orderedNames) {
        return OlapBuilderNamedDefinitionHelper.order(this.measures, orderedNames);
    }

    public void fixForSelectedMeasures() {
        ArrayList<IOlapBuilderMeasureDef> selectedMeasures = new ArrayList<IOlapBuilderMeasureDef>();
        if (this.measures != null) {
            for (IOlapBuilderMeasureDef measure : this.measures) {
                if (!(measure instanceof OlapBuilderMeasure) || !((OlapBuilderMeasure)measure).isSelected()) continue;
                selectedMeasures.add(measure);
            }
        }
        this.measures = selectedMeasures;
    }

    @Override
    public void solveReference(final OlapBuilderReferenceSolver referenceSolver) {
        this.dataView = null;
        this.dimensionMap.clear();
        this.dataView = referenceSolver.getTabularData(this.dataTableId);
        if (this.dataView != null && this.measures != null) {
            OlapBuilderErrorManager errorManager = referenceSolver.getErrorManager();
            int measuresSize = this.measures.size();
            for (int ii = 0; ii < measuresSize; ++ii) {
                final IOlapBuilderMeasureDef measure = this.measures.get(ii);
                OlapBuilderErrorManagerHelper.performValidation(errorManager, new Runnable(){
                    final /* synthetic */ OlapBuilderBaseFacts this$0;
                    {
                        OlapBuilderBaseFacts olapBuilderBaseFacts = this$0;
                        Objects.requireNonNull(olapBuilderBaseFacts);
                        this.this$0 = olapBuilderBaseFacts;
                    }

                    @Override
                    public void run() {
                        measure.solveReference(referenceSolver, (IOlapBuilderTabularDataDef)this.this$0.dataView);
                    }
                }, measure);
            }
        }
        int linksSize = this.links.size();
        for (int ii = 0; ii < linksSize; ++ii) {
            OlapBuilderLinkXmlDefinition entry = this.links.get(ii);
            String dimensionId = entry.getDimensionId();
            IOlapBuilderDimensionDef<?> dimension = referenceSolver.getDimension(dimensionId);
            if (dimension == null) continue;
            IOlapBuilderDataViewLinksDef link = entry.getLink();
            if (link != null) {
                IOlapBuilderTabularDataDef dataView = dimension.getDataView();
                link.solveReference(referenceSolver, dataView, (IOlapBuilderTabularDataDef)this.dataView);
            }
            if (link == null || link.getType() != OlapBuilderDataViewLinksType.NOT_MAPPED) {
                this.dimensionMap.put(dimension, link);
                continue;
            }
            this.dimensionNotMap.put(dimension, link);
        }
    }

    @Override
    public IOlapBuilderChangeDefinitionListener getDimensionListener() {
        return null;
    }

    protected String getDataTableName() {
        return this.dataView != null ? this.dataView.getName() : this.dataTableId;
    }

    public void addMeasure(IOlapBuilderMeasureDef measure) {
        this.measures.add(measure);
    }

    public boolean removeMeasure(IOlapBuilderMeasureDef measure) {
        return this.measures.remove(measure);
    }

    public void setRowFactAggregationType(OlapFactRowAggregationType rowFactAggregationType) {
        this.rowFactAggregationType = rowFactAggregationType;
    }

    @Nullable
    public IOlapBuilderCubeDef getCube() {
        return this.cube;
    }

    public void setCube(IOlapBuilderCubeDef cube) {
        this.cube = cube;
    }
}

