/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.csv;

import crazydev.common.utils.CdLineReader;
import crazydev.iccube.builder.datasource.csv.OlapBuilderCSVReader;
import crazydev.iccube.builder.datasource.file.OlapBuilderLineScanner;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderCSVLineScanner
extends OlapBuilderLineScanner {
    private final OlapBuilderCSVReader reader;

    public OlapBuilderCSVLineScanner(String tableName, CdLineReader reader, char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this(tableName, reader, null, separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace);
    }

    protected OlapBuilderCSVLineScanner(String tableName, CdLineReader reader, @Nullable String commentMarker, char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        super(tableName);
        this.reader = this.createReader(reader, commentMarker, separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace);
    }

    protected OlapBuilderCSVReader createReader(CdLineReader reader, @Nullable String commentMarker, char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        return new OlapBuilderCSVReader(reader, separator, quotechar, escape, 0, strictQuotes, ignoreLeadingWhiteSpace);
    }

    @Override
    public String[] nextLine() {
        try {
            String[] line = this.reader.readNext();
            return line;
        }
        catch (IOException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.LINE_TABLE_IO_ERROR, new Serializable[]{this.tableName, Integer.valueOf(this.getLineNumber()), ex.getMessage()});
        }
    }

    @Override
    public int getLineNumber() {
        if (this.reader != null) {
            return this.reader.getLineNumber();
        }
        return 0;
    }

    @Override
    public void closeQuietly() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getCurrentFileName() {
        return this.reader.getCurrentFileName();
    }
}

