/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.csv;

import crazydev.iccube.builder.common.OlapAbstractFileSystem;
import crazydev.iccube.builder.datasource.csv.OlapBuilderCSVConnection;
import crazydev.iccube.builder.datasource.csv.OlapBuilderCSVDataTable;
import crazydev.iccube.builder.datasource.csv.OlapBuilderHttpCSVDataTable;
import crazydev.iccube.builder.datasource.csv.OlapBuilderMultiFilesCSVDataTable;
import crazydev.iccube.builder.datasource.file.OlapBuilderAbstractFileDataSource;
import crazydev.iccube.builder.datasource.file.OlapBuilderDirectoryConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="fileCSV")
public class OlapBuilderCSVDataSource
extends OlapBuilderAbstractFileDataSource<OlapBuilderDirectoryConnection> {
    static final List<Class<? extends IOlapBuilderTabularDataDef>> CREATED_TABLE_TYPES_HTTP = Arrays.asList(OlapBuilderHttpCSVDataTable.class);
    static final List<Class<? extends IOlapBuilderTabularDataDef>> CREATED_TABLE_TYPES = Arrays.asList(OlapBuilderMultiFilesCSVDataTable.class);

    public OlapBuilderCSVDataSource() {
    }

    public OlapBuilderCSVDataSource(String directory) {
        super((File)null, directory);
    }

    @Override
    protected String getReportDataSourceType() {
        return "csv";
    }

    @Override
    protected String getReportDataSourceTypeCaption() {
        return "CSV Files";
    }

    @Override
    protected OlapBuilderCSVConnection createConnection(OlapAbstractFileSystem fs) {
        return new OlapBuilderCSVConnection(this, fs);
    }

    @Override
    @Nullable
    public List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes() {
        return this.isHttp() ? CREATED_TABLE_TYPES_HTTP : CREATED_TABLE_TYPES;
    }

    @Override
    public OlapBuilderBaseDataTable<OlapBuilderDirectoryConnection> createEmptyDiscoverTable(String tableName) {
        return new OlapBuilderCSVDataTable(tableName);
    }

    @Override
    public OlapBuilderBaseDataTable<OlapBuilderDirectoryConnection> createEmptyCreateTable(@Nullable Class<IOlapBuilderTabularDataDef> tableType) {
        OlapBuilderCSVDataTable table;
        if (OlapBuilderHttpCSVDataTable.class.equals(tableType)) {
            table = new OlapBuilderHttpCSVDataTable();
        } else if (OlapBuilderMultiFilesCSVDataTable.class.equals(tableType)) {
            table = new OlapBuilderMultiFilesCSVDataTable();
        } else {
            throw new RuntimeException("internal error : unexpected table type [" + (tableType != null ? tableType.getSimpleName() : "n/a") + "]");
        }
        return table;
    }
}

