/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.datasource.buffer.partition;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferConnection;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataTable;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataTableRow;
import crazydev.iccube.builder.datasource.buffer.partition.OlapBuilderPartitionedBufferDataTableFullRowReader;
import crazydev.iccube.builder.datasource.buffer.partition.OlapBuilderPartitionedBufferDataTableRowReader;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableRequestedPartitionKeys;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.enums.OlapIncrementalLoadStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderPartitionedBufferDataTable
extends OlapBuilderBaseDataTable<OlapBuilderBufferConnection> {
    private static long SHALLOW_SIZE_OF = -1L;
    private Map<IOlapBuilderTablePartitionKey, OlapBuilderBufferDataTable> tables;

    public OlapBuilderPartitionedBufferDataTable(String id, String tableName, List<IOlapBuilderDataColumnDef> columns, @Nullable OlapIncrementalLoadStrategy strategy, Map<IOlapBuilderTablePartitionKey, OlapBuilderBufferDataTable> tables) {
        super(tableName, columns);
        this.setIncrementalLoadStrategy(strategy);
        this.setId(id);
        this.tables = tables;
    }

    @Override
    public boolean hasTablePartitioning() {
        return true;
    }

    @Override
    @Nullable
    protected IOlapBuilderTableRowReader createRowReaderForRestore(OlapBuilderContext context, boolean tablePartition) {
        return null;
    }

    @Override
    protected List<IOlapBuilderTablePartitionKey> doGetPartitionKeys(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, @Nullable OlapBuilderTableRequestedPartitionKeys requestedPartitions) {
        if (requestedPartitions != null) {
            throw new RuntimeException("internal error: LOAD_PARTITIONS not supported w/ internal buffer table");
        }
        ArrayList<IOlapBuilderTablePartitionKey> keys = new ArrayList<IOlapBuilderTablePartitionKey>();
        for (IOlapBuilderTablePartitionKey key : this.tables.keySet()) {
            keys.add(key);
        }
        return keys;
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderBufferConnection> doCreatePartitionTableRowReaders(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, IOlapBuilderTablePartitionKey partitionKey) {
        OlapBuilderBufferDataTable table = this.tables.get(partitionKey);
        if (table == null) {
            throw new RuntimeException("internal error: buffer table [" + this.getName() + "] : missing partition [" + partitionKey.getName() + "]");
        }
        return new OlapBuilderPartitionedBufferDataTableRowReader(context, connectionPool, this, partitionKey, table.getData());
    }

    @Override
    protected IOlapBuilderTableRowReader<OlapBuilderBufferConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new OlapBuilderPartitionedBufferDataTableFullRowReader(context, connectionPool, maxRowCount, this);
    }

    public List<IOlapBuilderTableRow> asBuffer() {
        ArrayList<IOlapBuilderTableRow> buffer = new ArrayList<IOlapBuilderTableRow>();
        for (OlapBuilderBufferDataTable table : this.tables.values()) {
            List<OlapBuilderBufferDataTableRow> tData = table.getData();
            buffer.addAll(tData);
        }
        return buffer;
    }

    @Override
    public String getInternalFriendlyTypeName() {
        return "Partitioned Buffer Table";
    }

    public int size() {
        int size = 0;
        for (OlapBuilderBufferDataTable table : this.tables.values()) {
            size += table.size();
        }
        return size;
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        for (OlapBuilderBufferDataTable row : this.tables.values()) {
            size += row.sizeOf();
        }
        return size;
    }

    @Override
    @Nullable
    protected IOlapBuilderTableRowReader createRowReaderForTableCacheRead(OlapBuilderContext context) {
        return null;
    }

    @Override
    protected IOlapBuilderTableRowReader decorateRowReaderForTableCache(OlapBuilderContext context, IOlapBuilderTableRowReader reader) {
        return reader;
    }
}

